/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.linkeddata;

import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.signature.VerificationMethod;
import com.apicatalog.vc.method.resolver.MethodResolver;
import com.apicatalog.vc.proof.Proof;
import java.net.URI;
import org.eclipse.edc.iam.did.spi.document.DidDocument;
import org.eclipse.edc.iam.did.spi.resolution.DidResolverRegistry;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.verifiablecredentials.linkeddata.DataIntegrityKeyPair;

public class DidMethodResolver
implements MethodResolver {
    private final DidResolverRegistry resolverRegistry;

    public DidMethodResolver(DidResolverRegistry resolverRegistry) {
        this.resolverRegistry = resolverRegistry;
    }

    public VerificationMethod resolve(URI id, DocumentLoader documentLoader, Proof proof) throws DocumentError {
        DidDocument didDocument = (DidDocument)this.resolverRegistry.resolve(id.toString()).orElseThrow(failure -> new EdcException(failure.getFailureDetail()));
        return (VerificationMethod)didDocument.getVerificationMethod().stream().map(verificationMethod -> new DataIntegrityKeyPair(URI.create(verificationMethod.getId()), URI.create(verificationMethod.getType()), URI.create(verificationMethod.getController()), verificationMethod.serializePublicKey())).findFirst().orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Unknown, proof.method().type().toString()));
    }

    public boolean isAccepted(URI id) {
        return this.resolverRegistry.isSupported(id.toString());
    }
}

