/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.linkeddata;

import com.apicatalog.ld.signature.key.VerificationKey;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;

class DataIntegrityKeyPair
implements VerificationKey {
    private final URI id;
    private final URI type;
    private final URI controller;
    private final byte[] privateKey;
    private final byte[] publicKey;

    DataIntegrityKeyPair(URI id, URI type, URI controller, byte[] publicKey, byte[] privateKey) {
        this.id = id;
        this.type = type;
        this.controller = controller;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    DataIntegrityKeyPair(URI id, URI type, URI controller, byte[] publicKey) {
        this(id, type, controller, publicKey, null);
    }

    public URI id() {
        return this.id;
    }

    public URI type() {
        return this.type;
    }

    public URI controller() {
        return this.controller;
    }

    public byte[] privateKey() {
        return this.privateKey;
    }

    public String algorithm() {
        return this.type.toString();
    }

    public byte[] publicKey() {
        return this.publicKey;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.controller, Arrays.hashCode(this.privateKey), Arrays.hashCode(this.publicKey));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DataIntegrityKeyPair that = (DataIntegrityKeyPair)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.controller, that.controller) && Arrays.equals(this.privateKey, that.privateKey) && Arrays.equals(this.publicKey, that.publicKey);
    }

    public String toString() {
        return "DataIntegrityKeyPair[id=" + this.id + ", type=" + this.type + ", controller=" + this.controller + ", privateKey=" + Arrays.toString(this.privateKey) + ", publicKey=" + Arrays.toString(this.publicKey) + "]";
    }
}

