/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.jwt.rules;

import java.util.Map;
import org.eclipse.edc.jwt.validation.jti.JtiValidationEntry;
import org.eclipse.edc.jwt.validation.jti.JtiValidationStore;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JtiValidationRule
implements TokenValidationRule {
    private final JtiValidationStore jtiValidationStore;
    private final Monitor monitor;

    public JtiValidationRule(JtiValidationStore jtiValidationStore, Monitor monitor) {
        this.jtiValidationStore = jtiValidationStore;
        this.monitor = monitor;
    }

    public Result<Void> checkRule(@NotNull ClaimToken toVerify, @Nullable Map<String, Object> additional) {
        String jti = toVerify.getStringClaim("jti");
        if (jti != null) {
            JtiValidationEntry entry = this.jtiValidationStore.findById(jti);
            if (entry == null) {
                return Result.failure((String)"The JWT id '%s' was not found".formatted(jti));
            }
            if (entry.isExpired()) {
                this.monitor.warning("JTI Validation entry with id " + jti + " is expired", new Throwable[0]);
            }
        }
        return Result.success();
    }
}

