/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.jwt.rules;

import java.util.Map;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssuerKeyIdValidationRule
implements TokenValidationRule {
    private final String keyId;

    public IssuerKeyIdValidationRule(String tokenKeyIdHeader) {
        this.keyId = tokenKeyIdHeader;
    }

    public Result<Void> checkRule(@NotNull ClaimToken toVerify, @Nullable Map<String, Object> additional) {
        String iss = toVerify.getStringClaim("iss");
        return this.keyId.matches("%s#.*".formatted(iss)) ? Result.success() : Result.failure((String)"kid header '%s' expected to correlate to 'iss' claim ('%s'), but it did not.".formatted(this.keyId, iss));
    }
}

