/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.jwt.rules;

import java.util.Map;
import java.util.Objects;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssuerEqualsSubjectRule
implements TokenValidationRule {
    public Result<Void> checkRule(@NotNull ClaimToken toVerify, @Nullable Map<String, Object> additional) {
        String iss = toVerify.getStringClaim("iss");
        String sub = toVerify.getStringClaim("sub");
        return iss != null && Objects.equals(iss, sub) ? Result.success() : Result.failure((String)"The 'iss' and 'sub' claims must be non-null and identical.");
    }
}

