/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.jwt;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.edc.iam.identitytrust.spi.verification.CredentialVerifier;
import org.eclipse.edc.iam.identitytrust.spi.verification.VerifierContext;
import org.eclipse.edc.keys.spi.PublicKeyResolver;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.rules.AudienceValidationRule;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.eclipse.edc.token.spi.TokenValidationRulesRegistry;
import org.eclipse.edc.token.spi.TokenValidationService;
import org.eclipse.edc.verifiablecredentials.jwt.rules.IssuerKeyIdValidationRule;

public class JwtPresentationVerifier
implements CredentialVerifier {
    public static final String JWT_VC_TOKEN_CONTEXT = "dcp-vc";
    public static final String JWT_VP_TOKEN_CONTEXT = "dcp-vp";
    public static final String VERIFIABLE_CREDENTIAL_JSON_KEY = "verifiableCredential";
    public static final String VP_CLAIM = "vp";
    public static final String VC_CLAIM = "vc";
    private final ObjectMapper objectMapper;
    private final TokenValidationService tokenValidationService;
    private final TokenValidationRulesRegistry tokenValidationRulesRegistry;
    private final PublicKeyResolver publicKeyResolver;

    public JwtPresentationVerifier(ObjectMapper objectMapper, TokenValidationService tokenValidationService, TokenValidationRulesRegistry tokenValidationRulesRegistry, PublicKeyResolver publicKeyResolver) {
        this.objectMapper = objectMapper;
        this.tokenValidationService = tokenValidationService;
        this.tokenValidationRulesRegistry = tokenValidationRulesRegistry;
        this.publicKeyResolver = publicKeyResolver;
    }

    public boolean canHandle(String rawInput) {
        try {
            SignedJWT.parse((String)rawInput);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public Result<Void> verify(String serializedJwt, VerifierContext context) {
        Result verificationResult;
        try {
            SignedJWT signedJwt = SignedJWT.parse((String)serializedJwt);
            String keyId = signedJwt.getHeader().getKeyID();
            if (this.isCredential(signedJwt)) {
                ArrayList<IssuerKeyIdValidationRule> rules = new ArrayList<IssuerKeyIdValidationRule>(this.tokenValidationRulesRegistry.getRules(JWT_VC_TOKEN_CONTEXT));
                rules.add(new IssuerKeyIdValidationRule(keyId));
                return this.tokenValidationService.validate(serializedJwt, this.publicKeyResolver, rules).mapTo();
            }
            if (!this.isPresentation(signedJwt)) {
                return Result.failure((String)"Either '%s' or '%s' claim must be present in JWT.".formatted(VP_CLAIM, VC_CLAIM));
            }
            verificationResult = this.tokenValidationService.validate(serializedJwt, this.publicKeyResolver, this.vpValidationRules(context.getAudience(), keyId));
            Map vpClaim = (Map)signedJwt.getJWTClaimsSet().getClaim(VP_CLAIM);
            if (!vpClaim.containsKey(VERIFIABLE_CREDENTIAL_JSON_KEY)) {
                return Result.failure((String)"Presentation object did not contain mandatory object: verifiableCredential");
            }
            List<String> rawCredentials = this.extractCredentials(vpClaim.get(VERIFIABLE_CREDENTIAL_JSON_KEY));
            if (rawCredentials.isEmpty()) {
                return Result.success();
            }
            for (String token : rawCredentials) {
                verificationResult = verificationResult.merge(context.toBuilder().audience(signedJwt.getJWTClaimsSet().getIssuer()).build().verify(token));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return verificationResult.mapTo();
    }

    private List<TokenValidationRule> vpValidationRules(String audience, String keyId) {
        ArrayList<IssuerKeyIdValidationRule> rules = new ArrayList<IssuerKeyIdValidationRule>(this.tokenValidationRulesRegistry.getRules(JWT_VP_TOKEN_CONTEXT));
        rules.add(new IssuerKeyIdValidationRule(keyId));
        return Optional.ofNullable(audience).map(aud -> {
            ArrayList<AudienceValidationRule> r = new ArrayList<AudienceValidationRule>(rules);
            AudienceValidationRule audRule = new AudienceValidationRule(audience);
            r.add(audRule);
            return r;
        }).orElse(rules);
    }

    private boolean isCredential(SignedJWT jwt) throws ParseException {
        return jwt.getJWTClaimsSet().getClaims().containsKey(VC_CLAIM);
    }

    private boolean isPresentation(SignedJWT jwt) throws ParseException {
        return jwt.getJWTClaimsSet().getClaims().containsKey(VP_CLAIM);
    }

    private List<String> extractCredentials(Object credentialsObject) {
        if (credentialsObject instanceof Collection) {
            return ((Collection)credentialsObject).stream().map(obj -> {
                try {
                    return obj instanceof String ? obj.toString() : this.objectMapper.writeValueAsString(obj);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }).toList();
        }
        return List.of(credentialsObject.toString());
    }
}

