/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.verifiablecredentials.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class JwtCreationUtils {
    public static String createJwt(ECKey privateKey, String issuerId, String subject, String audience, Map<String, Object> claims) {
        try {
            ECDSASigner signer = new ECDSASigner(privateKey.toECPrivateKey());
            Date now = java.sql.Date.from(Instant.now());
            JWTClaimsSet.Builder claimsSet = new JWTClaimsSet.Builder().issuer(issuerId).subject(subject).issueTime(now).audience(audience).notBeforeTime(now).claim("jti", (Object)UUID.randomUUID().toString()).expirationTime(java.sql.Date.from(Instant.now().plusSeconds(60L)));
            claims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)claimsSet).claim(arg_0, arg_1));
            SignedJWT signedJwt = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(privateKey.getKeyID()).build(), claimsSet.build());
            signedJwt.sign((JWSSigner)signer);
            return signedJwt.serialize();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }
}

