/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.jwt.validation.jti;

import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public record JtiValidationEntry(String tokenId, @Nullable Long expirationTimestamp) {
    public JtiValidationEntry(String tokenId) {
        this(tokenId, null);
    }

    public boolean isExpired() {
        if (this.expirationTimestamp == null) {
            return false;
        }
        return Instant.ofEpochMilli(this.expirationTimestamp).isBefore(Instant.now());
    }

    @Nullable
    public Instant expirationTimestampAsInstant() {
        return this.expirationTimestamp != null ? Instant.ofEpochMilli(this.expirationTimestamp) : null;
    }
}

