/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.junit.testfixtures;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Scanner;
import org.opentest4j.AssertionFailedError;

public class TestUtils {
    public static final String GRADLE_WRAPPER;
    private static final String GRADLE_WRAPPER_UNIX = "gradlew";
    private static final String GRADLE_WRAPPER_WINDOWS = "gradlew.bat";
    private static File buildRoot;

    public static URI getResource(String name) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(name);
        if (resource == null) {
            throw new AssertionFailedError("Cannot find resource " + name);
        }
        try {
            return resource.toURI();
        }
        catch (URISyntaxException e) {
            throw new AssertionFailedError("Cannot find resource " + name, (Throwable)e);
        }
    }

    public static File getFileFromResourceName(String resourceName) {
        return new File(TestUtils.getResource(resourceName));
    }

    public static String getResourceFileContentAsString(String resourceName) {
        String string;
        block8: {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            try {
                Scanner scanner = new Scanner(Objects.requireNonNull(stream, "Not found: " + resourceName)).useDelimiter("\\A");
                String string2 = string = scanner.hasNext() ? scanner.next() : "";
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    public static String tempDirectory() {
        try {
            return Files.createTempDirectory(TestUtils.class.getSimpleName(), new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File findBuildRoot() {
        File canonicalFile;
        if (buildRoot != null) {
            return buildRoot;
        }
        try {
            canonicalFile = new File(".").getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not resolve current directory.", e);
        }
        buildRoot = TestUtils.findBuildRoot(canonicalFile);
        if (buildRoot == null) {
            throw new IllegalStateException("Could not find " + GRADLE_WRAPPER + " in parent directories.");
        }
        return buildRoot;
    }

    private static File findBuildRoot(File path) {
        File gradlew = new File(path, GRADLE_WRAPPER);
        if (gradlew.exists()) {
            return path;
        }
        File parent = path.getParentFile();
        if (parent != null) {
            return TestUtils.findBuildRoot(parent);
        }
        return null;
    }

    static {
        buildRoot = null;
        GRADLE_WRAPPER = System.getProperty("os.name").toLowerCase().contains("win") ? GRADLE_WRAPPER_WINDOWS : GRADLE_WRAPPER_UNIX;
    }
}

