/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.jtivalidation.store.sql;

import org.eclipse.edc.jtivalidation.store.sql.SqlJtiValidationStore;
import org.eclipse.edc.jtivalidation.store.sql.schema.JtiValidationStoreStatements;
import org.eclipse.edc.jtivalidation.store.sql.schema.postgres.PostgresDialectStatements;
import org.eclipse.edc.jwt.validation.jti.JtiValidationStore;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.bootstrapper.SqlSchemaBootstrapper;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Provides(value={JtiValidationStore.class})
@Extension(value="SQL JTI Validation store")
public class SqlJtiValidationStoreExtension
implements ServiceExtension {
    @Setting(description="The datasource to be used", defaultValue="default", key="edc.sql.store.jti.datasource")
    private String dataSourceName;
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext transactionContext;
    @Inject(required=false)
    private JtiValidationStoreStatements statements;
    @Inject
    private QueryExecutor queryExecutor;
    @Inject
    private TypeManager typeManager;
    @Inject
    private SqlSchemaBootstrapper sqlSchemaBootstrapper;

    public void initialize(ServiceExtensionContext context) {
        SqlJtiValidationStore sqlStore = new SqlJtiValidationStore(this.dataSourceRegistry, this.dataSourceName, this.transactionContext, this.typeManager.getMapper(), this.getStatementImpl(), this.queryExecutor, context.getMonitor());
        context.registerService(JtiValidationStore.class, (Object)sqlStore);
        this.sqlSchemaBootstrapper.addStatementFromResource(this.dataSourceName, "jti-validation-schema.sql");
    }

    private JtiValidationStoreStatements getStatementImpl() {
        return this.statements == null ? new PostgresDialectStatements() : this.statements;
    }
}

