/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.jtivalidation.store.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import org.eclipse.edc.jtivalidation.store.sql.schema.JtiValidationStoreStatements;
import org.eclipse.edc.jwt.validation.jti.JtiValidationEntry;
import org.eclipse.edc.jwt.validation.jti.JtiValidationStore;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.store.AbstractSqlStore;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class SqlJtiValidationStore
extends AbstractSqlStore
implements JtiValidationStore {
    private final JtiValidationStoreStatements statements;
    private final Monitor monitor;

    public SqlJtiValidationStore(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, ObjectMapper objectMapper, JtiValidationStoreStatements statements, QueryExecutor queryExecutor, Monitor monitor) {
        super(dataSourceRegistry, dataSourceName, transactionContext, objectMapper, queryExecutor);
        this.statements = statements;
        this.monitor = monitor;
    }

    public StoreResult<Void> storeEntry(JtiValidationEntry entry) {
        return (StoreResult)this.transactionContext.execute(() -> {
            String stmt = this.statements.getInsertTemplate();
            try (Connection connection = this.getConnection();){
                if (this.findByIdInternal(connection, entry.tokenId()) != null) {
                    StoreResult storeResult2 = StoreResult.alreadyExists((String)"JTI Validation Entry with ID '%s' already exists".formatted(entry.tokenId()));
                    return storeResult2;
                }
                this.queryExecutor.execute(connection, stmt, new Object[]{entry.tokenId(), entry.expirationTimestamp()});
                StoreResult storeResult = StoreResult.success();
                return storeResult;
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public JtiValidationEntry findById(String id, boolean autoRemove) {
        return (JtiValidationEntry)this.transactionContext.execute(() -> {
            JtiValidationEntry jtiValidationEntry;
            block9: {
                Connection connection = this.getConnection();
                try {
                    JtiValidationEntry entry = this.findByIdInternal(connection, id);
                    if (entry != null && autoRemove) {
                        this.deleteById(id).onFailure(f -> this.monitor.warning("Error deleting entry after lookup: '%s'".formatted(id), new Throwable[0]));
                    }
                    jtiValidationEntry = entry;
                    if (connection == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return jtiValidationEntry;
        });
    }

    public StoreResult<Void> deleteById(String id) {
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                if (this.findByIdInternal(connection, id) == null) {
                    StoreResult storeResult2 = StoreResult.notFound((String)"JTI Validation Entry with ID '%s' not found".formatted(id));
                    return storeResult2;
                }
                String stmt = this.statements.getDeleteByIdTemplate();
                this.queryExecutor.execute(connection, stmt, new Object[]{id});
                StoreResult storeResult = StoreResult.success();
                return storeResult;
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public StoreResult<Integer> deleteExpired() {
        return (StoreResult)this.transactionContext.execute(() -> {
            StoreResult storeResult;
            block8: {
                Connection connection = this.getConnection();
                try {
                    String stmt = this.statements.deleteWhereExpiredTemplate();
                    int rows = this.queryExecutor.execute(connection, stmt, new Object[]{Instant.now().toEpochMilli()});
                    storeResult = StoreResult.success((Object)rows);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return storeResult;
        });
    }

    private JtiValidationEntry findByIdInternal(Connection connection, String id) {
        String stmt = this.statements.getFindByTemplate();
        return (JtiValidationEntry)this.queryExecutor.single(connection, false, this::mapResultSet, stmt, new Object[]{id});
    }

    private JtiValidationEntry mapResultSet(ResultSet resultSet) throws Exception {
        long expiresAt = resultSet.getLong(this.statements.getExpirationTimeColumn());
        return new JtiValidationEntry(resultSet.getString(this.statements.getTokenIdColumn()), Long.valueOf(expiresAt));
    }
}

