/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.types.TypeManager;
import org.jetbrains.annotations.NotNull;

public class JacksonTypeManager
implements TypeManager {
    final ObjectMapper defaultMapper;
    final Map<String, ObjectMapper> objectMappers = new HashMap<String, ObjectMapper>();

    public JacksonTypeManager() {
        this.defaultMapper = new ObjectMapper();
        this.defaultMapper.registerModule((Module)new JavaTimeModule());
        this.defaultMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.defaultMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.registerContext("default", this.defaultMapper);
    }

    public ObjectMapper getMapper() {
        return this.defaultMapper;
    }

    @NotNull
    public ObjectMapper getMapper(String key) {
        return this.objectMappers.computeIfAbsent(key, k -> this.defaultMapper.copy());
    }

    public void registerContext(String key, ObjectMapper mapper) {
        this.objectMappers.put(key, mapper);
    }

    public void registerTypes(Class<?> ... type) {
        this.objectMappers.values().forEach(m -> m.registerSubtypes(type));
    }

    public void registerTypes(NamedType ... type) {
        this.objectMappers.values().forEach(m -> m.registerSubtypes(type));
    }

    public void registerTypes(String key, Class<?> ... type) {
        this.getMapper(key).registerSubtypes((Class[])type);
    }

    public void registerTypes(String key, NamedType ... type) {
        this.getMapper(key).registerSubtypes(type);
    }

    public <T> void registerSerializer(String key, Class<T> type, JsonSerializer<T> serializer) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(type, serializer);
        this.getMapper(key).registerModule((Module)module);
    }

    public <T> void registerSerializer(Class<T> type, JsonSerializer<T> serializer) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(type, serializer);
        this.getMapper().registerModule((Module)module);
    }

    public <T> T readValue(String input, TypeReference<T> typeReference) {
        try {
            return (T)this.getMapper().readValue(input, typeReference);
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    public <T> T readValue(String input, Class<T> type) {
        try {
            return (T)this.getMapper().readValue(input, type);
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    public <T> T readValue(byte[] bytes, Class<T> type) {
        try {
            return (T)this.getMapper().readValue(bytes, type);
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    public String writeValueAsString(Object value) {
        try {
            return this.getMapper().writeValueAsString(value);
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    public byte[] writeValueAsBytes(Object value) {
        try {
            return this.getMapper().writeValueAsBytes(value);
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    public String writeValueAsString(Object value, TypeReference<?> reference) {
        try {
            return this.getMapper().writerFor(reference).writeValueAsString(value);
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }
}

