/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.jsonld;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.edc.jsonld.JsonLdConfiguration;
import org.eclipse.edc.jsonld.TitaniumJsonLd;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.jsonld.util.JacksonJsonLd;
import org.eclipse.edc.runtime.metamodel.annotation.BaseExtension;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.spi.types.TypeManager;
import org.jetbrains.annotations.NotNull;

@BaseExtension
@Extension(value="JSON-LD Extension")
public class JsonLdExtension
implements ServiceExtension {
    public static final String NAME = "JSON-LD Extension";
    public static final String EDC_JSONLD_DOCUMENT_PREFIX = "edc.jsonld.document";
    public static final String EDC_JSONLD_DOCUMENT_CONFIG_ALIAS = "edc.jsonld.document.<documentAlias>.";
    @Setting(context="edc.jsonld.document.<documentAlias>.", value="Path of the JSON-LD document to cache", required=true)
    public static final String CONFIG_VALUE_PATH = "path";
    @Setting(context="edc.jsonld.document.<documentAlias>.", value="URL of the JSON-LD document to cache", required=true)
    public static final String CONFIG_VALUE_URL = "url";
    private static final boolean DEFAULT_HTTP_HTTPS_RESOLUTION = false;
    @Setting(value="If set enable http json-ld document resolution", type="boolean", defaultValue="false")
    private static final String HTTP_ENABLE_SETTING = "edc.jsonld.http.enabled";
    @Setting(value="If set enable https json-ld document resolution", type="boolean", defaultValue="false")
    private static final String HTTPS_ENABLE_SETTING = "edc.jsonld.https.enabled";
    private static final String DEFAULT_AVOID_VOCAB_CONTEXT = "false";
    @Setting(value="If true disable the @vocab context definition. This could be used to avoid api breaking changes", type="boolean", defaultValue="false")
    private static final String AVOID_VOCAB_CONTEXT = "edc.jsonld.vocab.disable";
    private static final boolean DEFAULT_CHECK_PREFIXES = true;
    @Setting(value="If true a validation on expended object will be made against configured prefixes", type="boolean", defaultValue="true")
    private static final String CHECK_PREFIXES = "edc.jsonld.prefixes.check";
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.typeManager.registerContext("json-ld", JacksonJsonLd.createObjectMapper());
    }

    @Provider
    public JsonLd createJsonLdService(ServiceExtensionContext context) {
        Config config = context.getConfig();
        JsonLdConfiguration configuration = JsonLdConfiguration.Builder.newInstance().httpEnabled(config.getBoolean(HTTP_ENABLE_SETTING, Boolean.valueOf(false)).booleanValue()).httpsEnabled(config.getBoolean(HTTPS_ENABLE_SETTING, Boolean.valueOf(false)).booleanValue()).checkPrefixes(config.getBoolean(CHECK_PREFIXES, Boolean.valueOf(true)).booleanValue()).build();
        Monitor monitor = context.getMonitor();
        TitaniumJsonLd service = new TitaniumJsonLd(monitor, configuration);
        if (!config.getBoolean(AVOID_VOCAB_CONTEXT, Boolean.valueOf(DEFAULT_AVOID_VOCAB_CONTEXT)).booleanValue()) {
            service.registerNamespace("@vocab", "https://w3id.org/edc/v0.0.1/ns/");
        }
        service.registerNamespace("edc", "https://w3id.org/edc/v0.0.1/ns/");
        Stream.of(new JsonLdContext("odrl.jsonld", "http://www.w3.org/ns/odrl.jsonld"), new JsonLdContext("dspace.jsonld", "https://w3id.org/dspace/2024/1/context.json")).forEach(jsonLdContext -> ((Result)this.getResourceUri("document/" + jsonLdContext.fileName()).onSuccess(uri -> service.registerCachedDocument(jsonLdContext.url(), uri))).onFailure(failure -> monitor.warning("Failed to register cached json-ld document: " + failure.getFailureDetail(), new Throwable[0])));
        this.registerCachedDocumentsFromConfig(context, service);
        return service;
    }

    private void registerCachedDocumentsFromConfig(ServiceExtensionContext context, TitaniumJsonLd service) {
        context.getConfig().getConfig(EDC_JSONLD_DOCUMENT_PREFIX).partition().forEach(config -> {
            Map tuple = config.getRelativeEntries();
            if (tuple.containsKey(CONFIG_VALUE_PATH) && tuple.containsKey(CONFIG_VALUE_URL)) {
                service.registerCachedDocument((String)tuple.get(CONFIG_VALUE_URL), new File((String)tuple.get(CONFIG_VALUE_PATH)).toURI());
            } else {
                context.getMonitor().warning(String.format("Expected a '%s' and a '%s' entry for '%s.%s', but found only '%s'", CONFIG_VALUE_PATH, CONFIG_VALUE_URL, EDC_JSONLD_DOCUMENT_PREFIX, config.currentNode(), String.join((CharSequence)"", tuple.keySet())), new Throwable[0]);
            }
        });
    }

    @NotNull
    private Result<URI> getResourceUri(String name) {
        URL uri = this.getClass().getClassLoader().getResource(name);
        if (uri == null) {
            return Result.failure((String)String.format("Cannot find resource %s", name));
        }
        try {
            return Result.success((Object)uri.toURI());
        }
        catch (URISyntaxException e) {
            return Result.failure((String)String.format("Cannot read resource %s: %s", name, e.getMessage()));
        }
    }

    record JsonLdContext(String fileName, String url) {
    }
}

