/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.jsonld.document;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.document.RdfDocument;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.edc.spi.result.Result;
import org.jetbrains.annotations.NotNull;

public class JarLoader
implements DocumentLoader {
    public Document loadDocument(URI uri, DocumentLoaderOptions options) throws JsonLdError {
        Document document;
        block10: {
            if (!"jar".equalsIgnoreCase(uri.getScheme())) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported URL scheme [" + uri.getScheme() + "]. JarLoader accepts only jar scheme.");
            }
            InputStream is = uri.toURL().openStream();
            try {
                Document document2 = (Document)this.createDocument(uri).apply(is).orElseThrow(f -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, f.getFailureDetail()));
                document2.setDocumentUrl(uri);
                document = document2;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "File not found [" + uri + "]: " + e.getMessage());
                }
                catch (IOException e) {
                    throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
                }
            }
            is.close();
        }
        return document;
    }

    @NotNull
    private Function<InputStream, Result<Document>> createDocument(URI uri) {
        MediaType type = this.detectedContentType(uri.getSchemeSpecificPart().toLowerCase()).orElse(MediaType.JSON);
        if (JsonDocument.accepts((MediaType)type)) {
            return this.jsonDocumentResolver(type);
        }
        if (RdfDocument.accepts((MediaType)type)) {
            return this.rdfDocumentResolver(type);
        }
        return s -> Result.failure((String)"cannot read document");
    }

    @NotNull
    private Function<InputStream, Result<Document>> jsonDocumentResolver(MediaType type) {
        return stream -> {
            try {
                return Result.success((Object)JsonDocument.of((MediaType)type, (InputStream)stream));
            }
            catch (JsonLdError e) {
                return Result.failure((String)e.getMessage());
            }
        };
    }

    @NotNull
    private Function<InputStream, Result<Document>> rdfDocumentResolver(MediaType type) {
        return stream -> {
            try {
                return Result.success((Object)RdfDocument.of((MediaType)type, (InputStream)stream));
            }
            catch (JsonLdError e) {
                return Result.failure((String)e.getMessage());
            }
        };
    }

    private Optional<MediaType> detectedContentType(String name) {
        if (name == null || StringUtils.isBlank((String)name)) {
            return Optional.empty();
        }
        if (name.endsWith(".nq")) {
            return Optional.of(MediaType.N_QUADS);
        }
        if (name.endsWith(".json")) {
            return Optional.of(MediaType.JSON);
        }
        if (name.endsWith(".jsonld")) {
            return Optional.of(MediaType.JSON_LD);
        }
        if (name.endsWith(".html")) {
            return Optional.of(MediaType.HTML);
        }
        return Optional.empty();
    }
}

