/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.jsonld;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.loader.FileLoader;
import com.apicatalog.jsonld.loader.HttpLoader;
import com.apicatalog.jsonld.loader.SchemeRouter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.jsonld.JsonLdConfiguration;
import org.eclipse.edc.jsonld.document.JarLoader;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;

public class TitaniumJsonLd
implements JsonLd {
    private static final Map<String, String> EMPTY_NAMESPACES = Collections.emptyMap();
    private static final Set<String> EMPTY_CONTEXTS = Collections.emptySet();
    private final Monitor monitor;
    private final Map<String, Map<String, String>> scopedNamespaces = new HashMap<String, Map<String, String>>();
    private final Map<String, Set<String>> scopedContexts = new HashMap<String, Set<String>>();
    private final CachedDocumentLoader documentLoader;

    public TitaniumJsonLd(Monitor monitor) {
        this(monitor, JsonLdConfiguration.Builder.newInstance().build());
    }

    public TitaniumJsonLd(Monitor monitor, JsonLdConfiguration configuration) {
        this.monitor = monitor;
        this.documentLoader = new CachedDocumentLoader(configuration, monitor);
    }

    public Result<JsonObject> expand(JsonObject json) {
        try {
            JsonDocument document = JsonDocument.of((JsonStructure)this.injectVocab(json));
            JsonArray expanded = com.apicatalog.jsonld.JsonLd.expand((Document)document).options(new JsonLdOptions((DocumentLoader)this.documentLoader)).get();
            if (expanded.size() > 0) {
                return Result.success((Object)expanded.getJsonObject(0));
            }
            return Result.failure((String)"Error expanding JSON-LD structure: result was empty, it could be caused by missing '@context'");
        }
        catch (JsonLdError error) {
            this.monitor.warning("Error expanding JSON-LD structure", new Throwable[]{error});
            return Result.failure((String)error.getMessage());
        }
    }

    public Result<JsonObject> compact(JsonObject json, String scope) {
        try {
            JsonDocument document = JsonDocument.of((JsonStructure)json);
            JsonBuilderFactory jsonFactory = Json.createBuilderFactory(Map.of());
            JsonDocument contextDocument = JsonDocument.of((JsonStructure)jsonFactory.createObjectBuilder().add("@context", this.createContext(scope)).build());
            JsonObject compacted = com.apicatalog.jsonld.JsonLd.compact((Document)document, (Document)contextDocument).options(new JsonLdOptions((DocumentLoader)this.documentLoader)).get();
            return Result.success((Object)compacted);
        }
        catch (JsonLdError e) {
            this.monitor.warning("Error compacting JSON-LD structure", new Throwable[]{e});
            return Result.failure((String)e.getMessage());
        }
    }

    public void registerNamespace(String prefix, String contextIri, String scope) {
        Map namespaces = this.scopedNamespaces.computeIfAbsent(scope, k -> new LinkedHashMap());
        namespaces.put(prefix, contextIri);
    }

    public void registerContext(String contextIri, String scope) {
        Set contexts = this.scopedContexts.computeIfAbsent(scope, k -> new LinkedHashSet());
        contexts.add(contextIri);
    }

    public void registerCachedDocument(String contextUrl, URI uri) {
        this.documentLoader.register(contextUrl, uri);
    }

    private JsonObject injectVocab(JsonObject json) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder((JsonObject)json);
        if (json.get((Object)"@context") instanceof JsonObject) {
            JsonObject contextObject = Optional.ofNullable(json.getJsonObject("@context")).orElseGet(() -> Json.createObjectBuilder().build());
            JsonObjectBuilder contextBuilder = Json.createObjectBuilder((JsonObject)contextObject);
            if (!contextObject.containsKey((Object)"@vocab")) {
                JsonObject newContextObject = contextBuilder.add("@vocab", "https://w3id.org/edc/v0.0.1/ns/").build();
                jsonObjectBuilder.add("@context", (JsonValue)newContextObject);
            }
        }
        return jsonObjectBuilder.build();
    }

    private JsonValue createContext(String scope) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        Stream.concat(this.namespacesForScope("*"), this.namespacesForScope(scope)).forEach(entry -> builder.add((String)entry.getKey(), (String)entry.getValue()));
        Set<String> contexts = Stream.concat(this.contextsForScope("*"), this.contextsForScope(scope)).collect(Collectors.toSet());
        JsonObject contextObject = builder.build();
        if (!contexts.isEmpty()) {
            JsonArrayBuilder contextArray = Json.createArrayBuilder();
            contexts.forEach(arg_0 -> ((JsonArrayBuilder)contextArray).add(arg_0));
            if (!contextObject.isEmpty()) {
                contextArray.add((JsonValue)contextObject);
            }
            return contextArray.build();
        }
        return contextObject;
    }

    private Stream<Map.Entry<String, String>> namespacesForScope(String scope) {
        return this.scopedNamespaces.getOrDefault(scope, EMPTY_NAMESPACES).entrySet().stream();
    }

    private Stream<String> contextsForScope(String scope) {
        return this.scopedContexts.getOrDefault(scope, EMPTY_CONTEXTS).stream();
    }

    private static class CachedDocumentLoader
    implements DocumentLoader {
        private final Map<String, URI> uriCache = new HashMap<String, URI>();
        private final Map<URI, Document> documentCache = new HashMap<URI, Document>();
        private final DocumentLoader loader;
        private final Monitor monitor;

        CachedDocumentLoader(JsonLdConfiguration configuration, Monitor monitor) {
            this.loader = new SchemeRouter().set("http", (DocumentLoader)(configuration.isHttpEnabled() ? HttpLoader.defaultInstance() : null)).set("https", (DocumentLoader)(configuration.isHttpsEnabled() ? HttpLoader.defaultInstance() : null)).set("file", (DocumentLoader)new FileLoader()).set("jar", (DocumentLoader)new JarLoader());
            this.monitor = monitor;
        }

        public Document loadDocument(URI url, DocumentLoaderOptions options) throws JsonLdError {
            URI uri = Optional.of(url.toString()).map(this.uriCache::get).orElse(url);
            return Optional.ofNullable(this.documentCache.get(uri)).orElse(this.loader.loadDocument(uri, options));
        }

        public void register(String contextUrl, URI uri) {
            this.uriCache.put(contextUrl, uri);
            try {
                this.documentCache.put(uri, this.loader.loadDocument(uri, new DocumentLoaderOptions()));
            }
            catch (JsonLdError e) {
                this.monitor.warning("Error caching context URL '%s' for URI '%s'. Subsequent attempts to expand this context URL may fail.".formatted(contextUrl, uri), new Throwable[0]);
            }
        }
    }
}

