/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.jsonld;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.loader.FileLoader;
import com.apicatalog.jsonld.loader.HttpLoader;
import com.apicatalog.jsonld.loader.SchemeRouter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.edc.jsonld.JsonLdConfiguration;
import org.eclipse.edc.jsonld.document.JarLoader;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;

public class TitaniumJsonLd
implements JsonLd {
    private final Monitor monitor;
    private final Map<String, String> additionalNamespaces = new HashMap<String, String>();
    private final CachedDocumentLoader documentLoader;

    public TitaniumJsonLd(Monitor monitor) {
        this(monitor, JsonLdConfiguration.Builder.newInstance().build());
    }

    public TitaniumJsonLd(Monitor monitor, JsonLdConfiguration configuration) {
        this.monitor = monitor;
        this.documentLoader = new CachedDocumentLoader(configuration);
    }

    public Result<JsonObject> expand(JsonObject json) {
        try {
            JsonDocument document = JsonDocument.of((JsonStructure)this.injectVocab(json));
            JsonArray expanded = com.apicatalog.jsonld.JsonLd.expand((Document)document).options(new JsonLdOptions((DocumentLoader)this.documentLoader)).get();
            if (expanded.size() > 0) {
                return Result.success((Object)expanded.getJsonObject(0));
            }
            return Result.failure((String)"Error expanding JSON-LD structure: result was empty, it could be caused by missing '@context'");
        }
        catch (JsonLdError error) {
            this.monitor.warning("Error expanding JSON-LD structure", new Throwable[]{error});
            return Result.failure((String)error.getMessage());
        }
    }

    public Result<JsonObject> compact(JsonObject json) {
        try {
            JsonDocument document = JsonDocument.of((JsonStructure)json);
            JsonBuilderFactory jsonFactory = Json.createBuilderFactory(Map.of());
            JsonDocument contextDocument = JsonDocument.of((JsonStructure)jsonFactory.createObjectBuilder().add("@context", (JsonValue)this.createContextObject()).build());
            JsonObject compacted = com.apicatalog.jsonld.JsonLd.compact((Document)document, (Document)contextDocument).get();
            return Result.success((Object)compacted);
        }
        catch (JsonLdError e) {
            this.monitor.warning("Error compacting JSON-LD structure", new Throwable[]{e});
            return Result.failure((String)e.getMessage());
        }
    }

    public void registerNamespace(String prefix, String contextIri) {
        this.additionalNamespaces.put(prefix, contextIri);
    }

    public void registerCachedDocument(String contextUrl, URI uri) {
        this.documentLoader.register(contextUrl, uri);
    }

    private JsonObject injectVocab(JsonObject json) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder((JsonObject)json);
        if (json.get((Object)"@context") instanceof JsonObject) {
            JsonObject contextObject = Optional.ofNullable(json.getJsonObject("@context")).orElseGet(() -> Json.createObjectBuilder().build());
            JsonObjectBuilder contextBuilder = Json.createObjectBuilder((JsonObject)contextObject);
            if (!contextObject.containsKey((Object)"@vocab")) {
                JsonObject newContextObject = contextBuilder.add("@vocab", "https://w3id.org/edc/v0.0.1/ns/").build();
                jsonObjectBuilder.add("@context", (JsonValue)newContextObject);
            }
        }
        return jsonObjectBuilder.build();
    }

    private JsonObject createContextObject() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.additionalNamespaces.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        return builder.build();
    }

    private static class CachedDocumentLoader
    implements DocumentLoader {
        private final Map<String, URI> cache = new HashMap<String, URI>();
        private final DocumentLoader loader;

        CachedDocumentLoader(JsonLdConfiguration configuration) {
            this.loader = new SchemeRouter().set("http", (DocumentLoader)(configuration.isHttpEnabled() ? HttpLoader.defaultInstance() : null)).set("https", (DocumentLoader)(configuration.isHttpsEnabled() ? HttpLoader.defaultInstance() : null)).set("file", (DocumentLoader)new FileLoader()).set("jar", (DocumentLoader)new JarLoader());
        }

        public Document loadDocument(URI url, DocumentLoaderOptions options) throws JsonLdError {
            URI uri = Optional.of(url.toString()).map(this.cache::get).orElse(url);
            return this.loader.loadDocument(uri, options);
        }

        public void register(String contextUrl, URI uri) {
            this.cache.put(contextUrl, uri);
        }
    }
}

