/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.jsonld;

public class JsonLdConfiguration {
    private boolean httpEnabled = false;
    private boolean httpsEnabled = false;
    private boolean checkPrefixes = true;

    private JsonLdConfiguration() {
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public boolean shouldCheckPrefixes() {
        return this.checkPrefixes;
    }

    public static class Builder {
        private final JsonLdConfiguration configuration = new JsonLdConfiguration();

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder httpEnabled(boolean httpEnabled) {
            this.configuration.httpEnabled = httpEnabled;
            return this;
        }

        public Builder httpsEnabled(boolean httpsEnabled) {
            this.configuration.httpsEnabled = httpsEnabled;
            return this;
        }

        public Builder checkPrefixes(boolean checkPrefixes) {
            this.configuration.checkPrefixes = checkPrefixes;
            return this;
        }

        public JsonLdConfiguration build() {
            return this.configuration;
        }
    }
}

