/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api.authorization;

import jakarta.ws.rs.core.SecurityContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.edc.identityhub.spi.authorization.AuthorizationService;
import org.eclipse.edc.identityhub.spi.participantcontext.model.ParticipantResource;
import org.eclipse.edc.spi.result.ServiceResult;

public class AuthorizationServiceImpl
implements AuthorizationService {
    private final Map<Class<?>, Function<String, ParticipantResource>> resourceLookupFunctions = new HashMap();

    public ServiceResult<Void> isAuthorized(SecurityContext securityContext, String resourceId, Class<? extends ParticipantResource> resourceClass) {
        if (securityContext.isUserInRole("admin")) {
            return ServiceResult.success();
        }
        Function<String, ParticipantResource> function = this.resourceLookupFunctions.get(resourceClass);
        String name = securityContext.getUserPrincipal().getName();
        if (function == null) {
            return ServiceResult.unauthorized((String)"User access for '%s' to resource ID '%s' of type '%s' cannot be verified".formatted(name, resourceClass, resourceClass));
        }
        ParticipantResource result = function.apply(resourceId);
        if (result != null) {
            return Objects.equals(result.getParticipantContextId(), name) ? ServiceResult.success() : ServiceResult.unauthorized((String)"User '%s' is not authorized to access resource of type %s with ID '%s'.".formatted(name, resourceClass, resourceId));
        }
        return ServiceResult.notFound((String)"No Resource of type '%s' with ID '%s' was found.".formatted(resourceClass, resourceId));
    }

    public void addLookupFunction(Class<?> resourceClass, Function<String, ParticipantResource> lookupFunction) {
        this.resourceLookupFunctions.put(resourceClass, lookupFunction);
    }
}

