/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api.authentication.filter;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.util.List;
import org.eclipse.edc.identityhub.spi.authentication.ServicePrincipal;
import org.eclipse.edc.identityhub.spi.authentication.ServicePrincipalResolver;

@PreMatching
@Priority(value=1000)
public class ServicePrincipalAuthenticationFilter
implements ContainerRequestFilter {
    private static final String API_KEY_HEADER = "x-api-key";
    private final ServicePrincipalResolver servicePrincipalResolver;

    public ServicePrincipalAuthenticationFilter(ServicePrincipalResolver servicePrincipalResolver) {
        this.servicePrincipalResolver = servicePrincipalResolver;
    }

    public void filter(final ContainerRequestContext containerRequestContext) {
        List apiKeyHeader = (List)containerRequestContext.getHeaders().get((Object)API_KEY_HEADER);
        if (apiKeyHeader == null || apiKeyHeader.size() != 1) {
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        } else {
            String apiKey = (String)apiKeyHeader.get(0);
            final ServicePrincipal servicePrincipal = this.servicePrincipalResolver.findByCredential(apiKey);
            containerRequestContext.setSecurityContext(new SecurityContext(){

                public Principal getUserPrincipal() {
                    return servicePrincipal;
                }

                public boolean isUserInRole(String s) {
                    return servicePrincipal.getRoles().contains(s);
                }

                public boolean isSecure() {
                    return containerRequestContext.getUriInfo().getBaseUri().toString().startsWith("https");
                }

                public String getAuthenticationScheme() {
                    return null;
                }
            });
        }
    }
}

