/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api.authentication.filter;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Arrays;
import java.util.List;

@Priority(value=2000)
class RoleBasedAccessFilter
implements ContainerRequestFilter {
    private final List<String> allowedRoles;

    RoleBasedAccessFilter(String ... allowedRoles) {
        this.allowedRoles = Arrays.asList(allowedRoles);
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        SecurityContext securityContext = containerRequestContext.getSecurityContext();
        if (this.allowedRoles.stream().noneMatch(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0))) {
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
    }
}

