/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api;

import java.util.Base64;
import java.util.List;
import org.eclipse.edc.identityhub.spi.authentication.ServicePrincipal;
import org.eclipse.edc.identityhub.spi.authentication.ServicePrincipalResolver;
import org.eclipse.edc.identityhub.spi.participantcontext.ParticipantContextService;
import org.eclipse.edc.identityhub.spi.participantcontext.model.ParticipantContext;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.web.spi.exception.AuthenticationFailedException;

class ParticipantServicePrincipalResolver
implements ServicePrincipalResolver {
    private final ParticipantContextService participantContextService;
    private final Vault vault;

    ParticipantServicePrincipalResolver(ParticipantContextService participantContextService, Vault vault) {
        this.participantContextService = participantContextService;
        this.vault = vault;
    }

    public ServicePrincipal findByCredential(String credential) {
        String[] tokens = credential.split("\\.");
        if (tokens.length != 2) {
            throw new AuthenticationFailedException("Invalid API token");
        }
        byte[] principalId = Base64.getDecoder().decode(tokens[0]);
        ServicePrincipal user = this.findByPrincipal(new String(principalId));
        if (user.getCredential().equals(credential)) {
            return user;
        }
        throw new AuthenticationFailedException("Invalid API token");
    }

    private ServicePrincipal findByPrincipal(String principal) {
        return (ServicePrincipal)this.participantContextService.getParticipantContext(principal).map(this::toUser).orElseThrow(f -> new AuthenticationFailedException("Invalid Authentication '%s': %s".formatted(principal, f.getFailureDetail())));
    }

    private ServicePrincipal toUser(final ParticipantContext participantContext) {
        final String credential = this.vault.resolveSecret(participantContext.getApiTokenAlias());
        final String participantContextId = participantContext.getParticipantContextId();
        return new ServicePrincipal(){

            public String getPrincipal() {
                return participantContextId;
            }

            public String getCredential() {
                return credential;
            }

            public List<String> getRoles() {
                return participantContext.getRoles();
            }
        };
    }
}

