/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.store.sql.keypair;

import org.eclipse.edc.identityhub.spi.keypair.store.KeyPairResourceStore;
import org.eclipse.edc.identityhub.store.sql.keypair.KeyPairResourceStoreStatements;
import org.eclipse.edc.identityhub.store.sql.keypair.SqlKeyPairResourceStore;
import org.eclipse.edc.identityhub.store.sql.keypair.schema.postgres.PostgresDialectStatements;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.bootstrapper.SqlSchemaBootstrapper;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Extension(value="KeyPair Resource SQL Store Extension")
public class SqlKeyPairResourceStoreExtension
implements ServiceExtension {
    public static final String NAME = "KeyPair Resource SQL Store Extension";
    @Setting(description="The datasource to be used", defaultValue="default", key="edc.sql.store.keypair.datasource")
    private String dataSourceName;
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext transactionContext;
    @Inject
    private TypeManager typemanager;
    @Inject
    private QueryExecutor queryExecutor;
    @Inject(required=false)
    private KeyPairResourceStoreStatements statements;
    @Inject
    private SqlSchemaBootstrapper sqlSchemaBootstrapper;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.sqlSchemaBootstrapper.addStatementFromResource(this.dataSourceName, "keypairs-schema.sql");
    }

    @Provider
    public KeyPairResourceStore createSqlStore(ServiceExtensionContext context) {
        return new SqlKeyPairResourceStore(this.dataSourceRegistry, this.dataSourceName, this.transactionContext, this.typemanager.getMapper(), this.queryExecutor, this.getStatementImpl());
    }

    private KeyPairResourceStoreStatements getStatementImpl() {
        return this.statements != null ? this.statements : new PostgresDialectStatements();
    }
}

