/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.store.sql.keypair;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.edc.identityhub.spi.keypair.model.KeyPairResource;
import org.eclipse.edc.identityhub.spi.keypair.store.KeyPairResourceStore;
import org.eclipse.edc.identityhub.store.sql.keypair.KeyPairResourceStoreStatements;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.store.AbstractSqlStore;
import org.eclipse.edc.sql.translation.SqlQueryStatement;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class SqlKeyPairResourceStore
extends AbstractSqlStore
implements KeyPairResourceStore {
    private final KeyPairResourceStoreStatements statements;

    public SqlKeyPairResourceStore(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, ObjectMapper objectMapper, QueryExecutor queryExecutor, KeyPairResourceStoreStatements statements) {
        super(dataSourceRegistry, dataSourceName, transactionContext, objectMapper, queryExecutor);
        this.statements = statements;
    }

    public StoreResult<Void> create(KeyPairResource keyPairResource) {
        Objects.requireNonNull(keyPairResource);
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                if (this.findByIdInternal(connection, keyPairResource.getId()) != null) {
                    StoreResult storeResult2 = StoreResult.alreadyExists((String)"A KeyPairResource with ID '%s' already exists.".formatted(keyPairResource.getId()));
                    return storeResult2;
                }
                String stmt = this.statements.getInsertTemplate();
                this.queryExecutor.execute(connection, stmt, new Object[]{keyPairResource.getId(), keyPairResource.getParticipantContextId(), keyPairResource.getTimestamp(), keyPairResource.getKeyId(), keyPairResource.getGroupName(), keyPairResource.isDefaultPair(), keyPairResource.getUseDuration(), keyPairResource.getRotationDuration(), keyPairResource.getSerializedPublicKey(), keyPairResource.getPrivateKeyAlias(), keyPairResource.getState(), keyPairResource.getKeyContext()});
                StoreResult storeResult = StoreResult.success();
                return storeResult;
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public StoreResult<Collection<KeyPairResource>> query(QuerySpec querySpec) {
        return (StoreResult)this.transactionContext.execute(() -> {
            StoreResult storeResult;
            block8: {
                Connection connection = this.getConnection();
                try {
                    SqlQueryStatement query = this.statements.createQuery(querySpec);
                    storeResult = StoreResult.success(this.queryExecutor.query(connection, true, this::mapResultSet, query.getQueryAsString(), query.getParameters()).toList());
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return storeResult;
        });
    }

    public StoreResult<Void> update(KeyPairResource keyPairResource) {
        Objects.requireNonNull(keyPairResource);
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                String id = keyPairResource.getId();
                if (this.findByIdInternal(connection, id) == null) {
                    StoreResult storeResult2 = StoreResult.notFound((String)"A KeyPairResource with ID '%s' does not exist.".formatted(id));
                    return storeResult2;
                }
                String updateStmt = this.statements.getUpdateTemplate();
                this.queryExecutor.execute(connection, updateStmt, new Object[]{id, keyPairResource.getParticipantContextId(), keyPairResource.getTimestamp(), keyPairResource.getKeyId(), keyPairResource.getGroupName(), keyPairResource.isDefaultPair(), keyPairResource.getUseDuration(), keyPairResource.getRotationDuration(), keyPairResource.getSerializedPublicKey(), keyPairResource.getPrivateKeyAlias(), keyPairResource.getState(), keyPairResource.getKeyContext(), id});
                StoreResult storeResult = StoreResult.success();
                return storeResult;
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public StoreResult<Void> deleteById(String id) {
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                if (this.findByIdInternal(connection, id) == null) {
                    StoreResult storeResult2 = StoreResult.notFound((String)"A KeyPairResource with ID '%s' does not exist.".formatted(id));
                    return storeResult2;
                }
                String deleteStmt = this.statements.getDeleteByIdTemplate();
                this.queryExecutor.execute(connection, deleteStmt, new Object[]{id});
                StoreResult storeResult = StoreResult.success();
                return storeResult;
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    @Nullable
    private KeyPairResource findByIdInternal(Connection connection, String id) {
        return (KeyPairResource)this.transactionContext.execute(() -> {
            String stmt = this.statements.getFindByIdTemplate();
            return (KeyPairResource)this.queryExecutor.single(connection, false, this::mapResultSet, stmt, new Object[]{id});
        });
    }

    private KeyPairResource mapResultSet(ResultSet resultSet) throws Exception {
        return ((KeyPairResource.Builder)KeyPairResource.Builder.newInstance().id(resultSet.getString(this.statements.getIdColumn())).participantContextId(resultSet.getString(this.statements.getParticipantIdColumn()))).timestamp(resultSet.getLong(this.statements.getTimestampColumn())).keyId(resultSet.getString(this.statements.getKeyIdColumn())).groupName(resultSet.getString(this.statements.getGroupNameColumn())).isDefaultPair(resultSet.getBoolean(this.statements.getIsDefaultKeyPairColumn())).useDuration(resultSet.getLong(this.statements.getUseDurationColumn())).rotationDuration(resultSet.getLong(this.statements.getRotationDurationColumn())).serializedPublicKey(resultSet.getString(this.statements.getSerializedPublicKeyColumn())).privateKeyAlias(resultSet.getString(this.statements.getPrivateKeyAliasColumn())).state(resultSet.getInt(this.statements.getStateColumn())).keyContext(resultSet.getString(this.statements.getKeyContextColumn())).build();
    }
}

