/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.iam.did.spi.document;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.nimbusds.jose.jwk.JWK;
import java.text.ParseException;
import java.util.Map;
import org.eclipse.edc.spi.EdcException;

@JsonDeserialize(builder=Builder.class)
public class VerificationMethod {
    private String id;
    private String type;
    private String controller;
    private String publicKeyMultibase;
    private Map<String, Object> publicKeyJwk;

    private VerificationMethod() {
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getController() {
        return this.controller;
    }

    public String getPublicKeyMultibase() {
        return this.publicKeyMultibase;
    }

    public Map<String, Object> getPublicKeyJwk() {
        return this.publicKeyJwk;
    }

    public byte[] serializePublicKey() {
        if (this.publicKeyJwk != null) {
            try {
                JWK jwk = JWK.parse(this.publicKeyJwk);
                return jwk.toJSONString().getBytes();
            }
            catch (ParseException e) {
                throw new EdcException((Throwable)e);
            }
        }
        if (this.publicKeyMultibase != null) {
            return this.publicKeyMultibase.getBytes();
        }
        throw new IllegalStateException("Either publicKeyJwk or publicKeyMultibase must be present, not both, not neither.");
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private final VerificationMethod method = new VerificationMethod();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.method.id = id;
            return this;
        }

        public Builder controller(String controller) {
            this.method.controller = controller;
            return this;
        }

        public Builder type(String type) {
            this.method.type = type;
            return this;
        }

        public Builder publicKeyJwk(Map<String, Object> jwk) {
            this.method.publicKeyJwk = jwk;
            return this;
        }

        public Builder publicKeyMultibase(String multibase) {
            this.method.publicKeyMultibase = multibase;
            return this;
        }

        public VerificationMethod build() {
            if (this.method.publicKeyMultibase != null && this.method.publicKeyJwk != null) {
                throw new IllegalArgumentException("Invalid public key material. Only one of publicKeyMultibase or publicKeyJwk should be provided.");
            }
            if (this.method.publicKeyMultibase == null && this.method.publicKeyJwk == null) {
                throw new IllegalArgumentException("One of publicKeyMultibase and publicKeyJwk must be provided.");
            }
            return this.method;
        }
    }
}

