/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.iam.did.spi.document;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.iam.did.spi.document.Service;
import org.eclipse.edc.iam.did.spi.document.VerificationMethod;

@JsonDeserialize(builder=Builder.class)
public class DidDocument {
    public static final String DID_CONTEXT = "https://www.w3.org/ns/did/v1";
    private final List<Service> service = new ArrayList<Service>();
    @JsonProperty(value="@context")
    private final List<Object> context = new ArrayList<Object>();
    private final List<VerificationMethod> verificationMethod = new ArrayList<VerificationMethod>();
    private final List<String> authentication = new ArrayList<String>();
    private String id;

    public String getId() {
        return this.id;
    }

    public List<Object> getContext() {
        return this.context;
    }

    public List<Service> getService() {
        return this.service;
    }

    public List<VerificationMethod> getVerificationMethod() {
        return this.verificationMethod;
    }

    public List<String> getAuthentication() {
        return this.authentication;
    }

    public String toString() {
        return this.getId();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private final DidDocument document = new DidDocument();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.document.id = id;
            return this;
        }

        @JsonProperty(value="@context")
        public Builder context(List<Object> context) {
            this.document.context.addAll(context);
            return this;
        }

        public Builder service(List<Service> services) {
            this.document.service.addAll(services);
            return this;
        }

        public Builder verificationMethod(List<VerificationMethod> verificationMethod) {
            this.document.verificationMethod.addAll(verificationMethod);
            return this;
        }

        public Builder authentication(List<String> authentication) {
            this.document.authentication.addAll(authentication);
            return this;
        }

        public DidDocument build() {
            if (!this.document.context.contains(DidDocument.DID_CONTEXT)) {
                this.document.context.add(DidDocument.DID_CONTEXT);
            }
            return this.document;
        }
    }
}

