/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.spi.http;

import dev.failsafe.Fallback;
import dev.failsafe.FallbackBuilder;
import dev.failsafe.function.CheckedFunction;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.Response;
import org.eclipse.edc.spi.http.EdcHttpClientException;
import org.eclipse.edc.spi.http.FallbackFactory;

public interface FallbackFactories {
    public static FallbackFactory retryWhenStatusNot2xxOr4xx() {
        return request -> {
            CheckedFunction exceptionSupplier = event -> {
                Response response = (Response)event.getLastResult();
                if (response == null) {
                    return new EdcHttpClientException(event.getLastException().getMessage());
                }
                return new EdcHttpClientException(String.format("Server response to [%s, %s] was not successful but was %s: %s", request.method(), request.url(), response.code(), response.body().string()));
            };
            return ((FallbackBuilder)Fallback.builderOfException((CheckedFunction)exceptionSupplier).handleResultIf(r -> !r.isSuccessful() && (r.code() < 400 || r.code() >= 500))).build();
        };
    }

    public static FallbackFactory retryWhenStatusIsNot(int status) {
        return FallbackFactories.retryWhenStatusIsNotIn(status);
    }

    public static FallbackFactory retryWhenStatusIsNotIn(int ... status) {
        Set codes = Arrays.stream(status).boxed().collect(Collectors.toSet());
        return request -> {
            CheckedFunction exceptionSupplier = event -> {
                Response response = (Response)event.getLastResult();
                if (response == null) {
                    return new EdcHttpClientException(event.getLastException().getMessage());
                }
                return new EdcHttpClientException(String.format("Server response to [%s, %s] was not one of %s but was %s: %s", request.method(), request.url(), Arrays.toString(status), response.code(), response.body().string()));
            };
            return ((FallbackBuilder)Fallback.builderOfException((CheckedFunction)exceptionSupplier).handleResultIf(r -> !codes.contains(r.code()))).build();
        };
    }
}

