/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.http.spi;

import dev.failsafe.Fallback;
import dev.failsafe.FallbackBuilder;
import dev.failsafe.event.ExecutionAttemptedEvent;
import dev.failsafe.function.CheckedFunction;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.Response;
import org.eclipse.edc.http.spi.EdcHttpClientException;
import org.eclipse.edc.http.spi.FallbackFactory;

public interface FallbackFactories {
    public static FallbackFactory retryWhenStatusNot2xxOr4xx() {
        return request -> ((FallbackBuilder)Fallback.builderOfException((CheckedFunction)new FallbackFunction("[2xx, 4xx]")).handleResultIf(r -> !r.isSuccessful() && (r.code() < 400 || r.code() >= 500))).build();
    }

    public static FallbackFactory retryWhenStatusIsNot(int status) {
        return FallbackFactories.retryWhenStatusIsNotIn(status);
    }

    public static FallbackFactory retryWhenStatusIsNotIn(int ... status) {
        Set codes = Arrays.stream(status).boxed().collect(Collectors.toSet());
        return request -> ((FallbackBuilder)Fallback.builderOfException((CheckedFunction)new FallbackFunction(Arrays.toString(status))).handleResultIf(r -> !codes.contains(r.code()))).build();
    }

    public record FallbackFunction(String expectedStatus) implements CheckedFunction<ExecutionAttemptedEvent<? extends Response>, Exception>
    {
        public Exception apply(ExecutionAttemptedEvent<? extends Response> event) throws Throwable {
            Response response = (Response)event.getLastResult();
            if (response == null) {
                return new EdcHttpClientException(event.getLastException().getMessage(), 0, null);
            }
            String responseBody = response.body().string();
            return new EdcHttpClientException(String.format("Server response to [%s, %s] was not one of %s but was %s: %s", response.request().method(), response.request().url(), this.expectedStatus, response.code(), responseBody), response.code(), responseBody);
        }
    }
}

