/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.store.sql.credentialrequest.schema;

import java.time.Clock;
import org.eclipse.edc.identityhub.spi.credential.request.store.HolderCredentialRequestStore;
import org.eclipse.edc.identityhub.store.sql.credentialrequest.schema.HolderCredentialRequestStoreStatements;
import org.eclipse.edc.identityhub.store.sql.credentialrequest.schema.SqlHolderCredentialRequestStore;
import org.eclipse.edc.identityhub.store.sql.credentialrequest.schema.schema.postgres.PostgresDialectStatements;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.bootstrapper.SqlSchemaBootstrapper;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Extension(value="Issuance Process SQL Store Extension")
public class SqlHolderCredentialRequestStoreExtension
implements ServiceExtension {
    public static final String NAME = "Issuance Process SQL Store Extension";
    @Setting(description="The datasource to be used", defaultValue="default", key="edc.sql.store.credentialrequest.datasource")
    private String dataSourceName;
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext transactionContext;
    @Inject
    private TypeManager typemanager;
    @Inject
    private QueryExecutor queryExecutor;
    @Inject(required=false)
    private HolderCredentialRequestStoreStatements statements;
    @Inject
    private SqlSchemaBootstrapper sqlSchemaBootstrapper;
    @Inject
    private Clock clock;

    public void initialize(ServiceExtensionContext context) {
        this.sqlSchemaBootstrapper.addStatementFromResource(this.dataSourceName, "holder-credential-request-schema.sql");
    }

    @Provider
    public HolderCredentialRequestStore createSqlStore(ServiceExtensionContext context) {
        return new SqlHolderCredentialRequestStore(this.dataSourceRegistry, this.dataSourceName, this.transactionContext, this.typemanager.getMapper(), this.queryExecutor, this.getStatementImpl(), context.getRuntimeId(), this.clock);
    }

    private HolderCredentialRequestStoreStatements getStatementImpl() {
        return this.statements != null ? this.statements : new PostgresDialectStatements();
    }
}

