/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.store.sql.credentialrequest.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.identityhub.spi.credential.request.model.HolderCredentialRequest;
import org.eclipse.edc.identityhub.spi.credential.request.store.HolderCredentialRequestStore;
import org.eclipse.edc.identityhub.store.sql.credentialrequest.schema.HolderCredentialRequestStoreStatements;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.lease.LeaseStatements;
import org.eclipse.edc.sql.lease.SqlLeaseContextBuilder;
import org.eclipse.edc.sql.store.AbstractSqlStore;
import org.eclipse.edc.sql.translation.SqlQueryStatement;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class SqlHolderCredentialRequestStore
extends AbstractSqlStore
implements HolderCredentialRequestStore {
    private final String leaseHolderName;
    private final SqlLeaseContextBuilder leaseContext;
    private final HolderCredentialRequestStoreStatements statements;
    private final Clock clock;

    public SqlHolderCredentialRequestStore(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, ObjectMapper objectMapper, QueryExecutor queryExecutor, HolderCredentialRequestStoreStatements statements, String leaseHolderName, Clock clock) {
        super(dataSourceRegistry, dataSourceName, transactionContext, objectMapper, queryExecutor);
        this.statements = statements;
        this.leaseHolderName = leaseHolderName;
        this.clock = clock;
        this.leaseContext = SqlLeaseContextBuilder.with((TransactionContext)transactionContext, (String)leaseHolderName, (LeaseStatements)statements, (Clock)clock, (QueryExecutor)queryExecutor);
    }

    public HolderCredentialRequest findById(String id) {
        return (HolderCredentialRequest)this.transactionContext.execute(() -> {
            HolderCredentialRequest holderCredentialRequest;
            block8: {
                Connection connection = this.getConnection();
                try {
                    holderCredentialRequest = this.findByIdInternal(connection, id);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return holderCredentialRequest;
        });
    }

    @NotNull
    public List<HolderCredentialRequest> nextNotLeased(int max, Criterion ... criteria) {
        return (List)this.transactionContext.execute(() -> {
            List filter = Arrays.stream(criteria).collect(Collectors.toList());
            QuerySpec querySpec = QuerySpec.Builder.newInstance().filter(filter).sortField("stateTimestamp").limit(Integer.valueOf(max)).build();
            SqlQueryStatement statement = this.statements.createQuery(querySpec).addWhereClause(this.statements.getNotLeasedFilter(), new Object[]{this.clock.millis()});
            try (Connection connection = this.getConnection();){
                List<HolderCredentialRequest> list;
                block14: {
                    Stream stream = this.queryExecutor.query(connection, true, this::mapResultSet, statement.getQueryAsString(), statement.getParameters());
                    try {
                        List<HolderCredentialRequest> issuanceProcesses = stream.collect(Collectors.toList());
                        issuanceProcesses.forEach(issuanceProcess -> this.leaseContext.withConnection(connection).acquireLease(issuanceProcess.getId()));
                        list = issuanceProcesses;
                        if (stream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return list;
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public StoreResult<HolderCredentialRequest> findByIdAndLease(String id) {
        return (StoreResult)this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                HolderCredentialRequest entity = this.findByIdInternal(connection, id);
                if (entity == null) {
                    StoreResult storeResult2 = StoreResult.notFound((String)String.format("HolderCredentialRequest %s not found", id));
                    return storeResult2;
                }
                this.leaseContext.withConnection(connection).acquireLease(entity.getId());
                StoreResult storeResult = StoreResult.success((Object)entity);
                return storeResult;
            }
            catch (IllegalStateException e) {
                return StoreResult.alreadyLeased((String)String.format("HolderCredentialRequest %s is already leased", id));
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public void save(HolderCredentialRequest issuanceProcess) {
        try (Connection conn = this.getConnection();){
            HolderCredentialRequest existing = this.findByIdInternal(conn, issuanceProcess.getId());
            if (existing != null) {
                this.leaseContext.by(this.leaseHolderName).withConnection(conn).breakLease(issuanceProcess.getId());
                this.update(conn, issuanceProcess);
            } else {
                this.insert(conn, issuanceProcess);
            }
        }
        catch (SQLException e) {
            throw new EdcPersistenceException((Throwable)e);
        }
    }

    public Collection<HolderCredentialRequest> query(QuerySpec querySpec) {
        return (Collection)this.transactionContext.execute(() -> {
            List list;
            block8: {
                Connection connection = this.getConnection();
                try {
                    SqlQueryStatement query = this.statements.createQuery(querySpec);
                    list = this.queryExecutor.query(connection, true, this::mapResultSet, query.getQueryAsString(), query.getParameters()).toList();
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return list;
        });
    }

    private void insert(Connection conn, HolderCredentialRequest process) {
        String insertTpStatement = this.statements.getInsertTemplate();
        this.queryExecutor.execute(conn, insertTpStatement, new Object[]{process.getId(), process.getState(), process.getStateCount(), process.getStateTimestamp(), process.getCreatedAt(), process.getUpdatedAt(), this.toJson(process.getTraceContext()), process.getErrorDetail(), process.getParticipantContextId(), process.getIssuerDid(), process.getIssuerPid(), this.toJson(process.getTypesAndFormats())});
    }

    private void update(Connection conn, HolderCredentialRequest process) {
        String updateStmt = this.statements.getUpdateTemplate();
        this.queryExecutor.execute(conn, updateStmt, new Object[]{process.getState(), process.getStateCount(), process.getStateTimestamp(), process.getUpdatedAt(), this.toJson(process.getTraceContext()), process.getErrorDetail(), process.getIssuerDid(), process.getIssuerPid(), this.toJson(process.getTypesAndFormats()), process.getId()});
    }

    private HolderCredentialRequest findByIdInternal(Connection connection, String id) {
        return (HolderCredentialRequest)this.transactionContext.execute(() -> {
            String stmt = this.statements.getFindByIdTemplate();
            return (HolderCredentialRequest)this.queryExecutor.single(connection, false, this::mapResultSet, stmt, new Object[]{id});
        });
    }

    private HolderCredentialRequest mapResultSet(ResultSet resultSet) throws Exception {
        return ((HolderCredentialRequest.Builder)((HolderCredentialRequest.Builder)((HolderCredentialRequest.Builder)((HolderCredentialRequest.Builder)((HolderCredentialRequest.Builder)((HolderCredentialRequest.Builder)((HolderCredentialRequest.Builder)HolderCredentialRequest.Builder.newInstance().id(resultSet.getString(this.statements.getIdColumn())).createdAt(resultSet.getLong(this.statements.getCreatedAtColumn()))).updatedAt(resultSet.getLong(this.statements.getUpdatedAtColumn()))).state(resultSet.getInt(this.statements.getStateColumn()))).stateTimestamp(resultSet.getLong(this.statements.getStateTimestampColumn()))).stateCount(resultSet.getInt(this.statements.getStateCountColumn()))).traceContext((Map)this.fromJson(resultSet.getString(this.statements.getTraceContextColumn()), this.getTypeRef()))).errorDetail(resultSet.getString(this.statements.getErrorDetailColumn()))).typesAndFormats((Map)this.fromJson(resultSet.getString(this.statements.getCredentialTypesColumn()), this.getTypeRef())).issuerDid(resultSet.getString(this.statements.getIssuerDidColumn())).issuerPid(resultSet.getString(this.statements.getissuerPidColumn())).participantContextId(resultSet.getString(this.statements.getParticipantIdColumn())).build();
    }
}

