/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.spi.credential.request.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.edc.identityhub.spi.credential.request.model.HolderRequestState;
import org.eclipse.edc.identityhub.spi.credential.request.model.RequestedCredential;
import org.eclipse.edc.spi.entity.Entity;
import org.eclipse.edc.spi.entity.StatefulEntity;

public class HolderCredentialRequest
extends StatefulEntity<HolderCredentialRequest> {
    private String participantContextId;
    private String issuerDid;
    private List<RequestedCredential> idsAndFormats = new ArrayList<RequestedCredential>();
    private String issuerPid;

    private HolderCredentialRequest() {
        this.state = HolderRequestState.CREATED.code();
    }

    public void transitionCreated() {
        this.state = HolderRequestState.CREATED.code();
        this.updateStateTimestamp();
    }

    public void transitionRequesting() {
        this.state = HolderRequestState.REQUESTING.code();
        this.updateStateTimestamp();
    }

    public void transitionRequested(String issuerPid) {
        this.state = HolderRequestState.REQUESTED.code();
        this.issuerPid = issuerPid;
        this.updateStateTimestamp();
    }

    public void transitionIssued(String issuerPid) {
        this.state = HolderRequestState.ISSUED.code();
        this.issuerPid = issuerPid;
        this.updateStateTimestamp();
    }

    public void transitionError(String detail) {
        this.state = HolderRequestState.ERROR.code();
        this.errorDetail = detail;
        this.updateStateTimestamp();
    }

    public String getParticipantContextId() {
        return this.participantContextId;
    }

    public String getIssuerDid() {
        return this.issuerDid;
    }

    public String getHolderPid() {
        return this.getId();
    }

    public List<RequestedCredential> getIdsAndFormats() {
        return this.idsAndFormats;
    }

    public HolderCredentialRequest copy() {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)Builder.newInstance().state(this.state)).id(this.id).requestedCredentials(List.copyOf(this.idsAndFormats)).issuerDid(this.issuerDid).participantContextId(this.participantContextId).issuerPid(this.issuerPid).errorDetail(this.errorDetail)).createdAt(this.createdAt)).updatedAt(this.updatedAt)).pending(this.pending)).stateCount(this.stateCount)).stateTimestamp(this.stateTimestamp)).clock(this.clock)).traceContext(Map.copyOf(this.traceContext))).build();
    }

    public String stateAsString() {
        return HolderRequestState.from(this.state).toString();
    }

    public HolderRequestState stateAsEnum() {
        return HolderRequestState.from(this.state);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Entity that = (Entity)o;
        return this.id.equals(that.getId());
    }

    public String getIssuerPid() {
        return this.issuerPid;
    }

    public static final class Builder
    extends StatefulEntity.Builder<HolderCredentialRequest, Builder> {
        Builder(HolderCredentialRequest entity) {
            super((StatefulEntity)entity);
        }

        public static Builder newInstance() {
            return new Builder(new HolderCredentialRequest());
        }

        public Builder id(String id) {
            ((HolderCredentialRequest)this.entity).id = id;
            return this;
        }

        public Builder self() {
            return this;
        }

        public Builder issuerDid(String issuerDid) {
            ((HolderCredentialRequest)this.entity).issuerDid = issuerDid;
            return this;
        }

        public Builder requestId(String requestId) {
            ((HolderCredentialRequest)this.entity).id = requestId;
            return this;
        }

        public Builder requestedCredentials(List<RequestedCredential> typesAndFormats) {
            ((HolderCredentialRequest)this.entity).idsAndFormats = typesAndFormats;
            return this;
        }

        public Builder requestedCredential(String credentialObjectId, String type, String format) {
            ((HolderCredentialRequest)this.entity).idsAndFormats.add(new RequestedCredential(credentialObjectId, type, format));
            return this;
        }

        public Builder participantContextId(String participantContextId) {
            ((HolderCredentialRequest)this.entity).participantContextId = participantContextId;
            return this;
        }

        public Builder issuerPid(String issuerPid) {
            ((HolderCredentialRequest)this.entity).issuerPid = issuerPid;
            return this;
        }

        public HolderCredentialRequest build() {
            super.build();
            Objects.requireNonNull(((HolderCredentialRequest)this.entity).issuerDid, "'issuerDid' cannot be null");
            Objects.requireNonNull(((HolderCredentialRequest)this.entity).idsAndFormats, "'idsAndFormats' cannot be null");
            Objects.requireNonNull(((HolderCredentialRequest)this.entity).participantContextId, "'participantContextId' cannot be null");
            if (((HolderCredentialRequest)this.entity).idsAndFormats.isEmpty()) {
                throw new IllegalArgumentException("idsAndFormats cannot be empty");
            }
            if (((HolderCredentialRequest)this.entity).state == 0) {
                throw new IllegalStateException("Issuance process state must be set to <> 0");
            }
            return (HolderCredentialRequest)this.entity;
        }
    }
}

