/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.edr.transform;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import org.eclipse.edc.edr.spi.types.EndpointDataReferenceEntry;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromEndpointDataReferenceEntryTransformer
extends AbstractJsonLdTransformer<EndpointDataReferenceEntry, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromEndpointDataReferenceEntryTransformer(JsonBuilderFactory jsonFactory) {
        super(EndpointDataReferenceEntry.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull EndpointDataReferenceEntry entry, @NotNull TransformerContext context) {
        return this.jsonFactory.createObjectBuilder().add("@id", entry.getId()).add("@type", "https://w3id.org/edc/v0.0.1/ns/EndpointDataReferenceEntry").add("https://w3id.org/edc/v0.0.1/ns/providerId", entry.getProviderId()).add("https://w3id.org/edc/v0.0.1/ns/assetId", entry.getAssetId()).add("https://w3id.org/edc/v0.0.1/ns/agreementId", entry.getAgreementId()).add("https://w3id.org/edc/v0.0.1/ns/transferProcessId", entry.getTransferProcessId()).add("https://w3id.org/edc/v0.0.1/ns/createdAt", entry.getCreatedAt()).add("https://w3id.org/edc/v0.0.1/ns/contractNegotiationId", entry.getContractNegotiationId()).build();
    }
}

