/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.edr;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.connector.controlplane.api.management.edr.transform.JsonObjectFromEndpointDataReferenceEntryTransformer;
import org.eclipse.edc.connector.controlplane.api.management.edr.v1.EdrCacheApiV1Controller;
import org.eclipse.edc.connector.controlplane.api.management.edr.v3.EdrCacheApiV3Controller;
import org.eclipse.edc.edr.spi.store.EndpointDataReferenceStore;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Management API: EDR cache")
public class EdrCacheApiExtension
implements ServiceExtension {
    public static final String NAME = "Management API: EDR cache";
    @Inject
    private WebService webService;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private JsonObjectValidatorRegistry validator;
    @Inject
    private EndpointDataReferenceStore edrStore;
    @Inject
    private Monitor monitor;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonBuilderFactory jsonFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry managementTypeTransformerRegistry = this.transformerRegistry.forContext("management-api");
        managementTypeTransformerRegistry.register((TypeTransformer)new JsonObjectFromEndpointDataReferenceEntryTransformer(jsonFactory));
        this.webService.registerResource("management", (Object)new EdrCacheApiV1Controller(this.edrStore, managementTypeTransformerRegistry, this.validator, this.monitor));
        this.webService.registerResource("management", (Object)new EdrCacheApiV3Controller(this.edrStore, managementTypeTransformerRegistry, this.validator, this.monitor));
    }
}

