/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.edr;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import java.util.List;
import org.eclipse.edc.edr.spi.store.EndpointDataReferenceStore;
import org.eclipse.edc.edr.spi.types.EndpointDataReferenceEntry;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

public class BaseEdrCacheApiController {
    protected final EndpointDataReferenceStore edrStore;
    protected final TypeTransformerRegistry transformerRegistry;
    protected final JsonObjectValidatorRegistry validator;
    protected final Monitor monitor;

    public BaseEdrCacheApiController(EndpointDataReferenceStore edrStore, TypeTransformerRegistry transformerRegistry, JsonObjectValidatorRegistry validator, Monitor monitor) {
        this.edrStore = edrStore;
        this.transformerRegistry = transformerRegistry;
        this.validator = validator;
        this.monitor = monitor;
    }

    public JsonArray requestEdrEntries(JsonObject querySpecJson) {
        QuerySpec querySpec;
        if (querySpecJson == null) {
            querySpec = QuerySpec.Builder.newInstance().build();
        } else {
            this.validator.validate("https://w3id.org/edc/v0.0.1/ns/QuerySpec", querySpecJson).orElseThrow(ValidationFailureException::new);
            querySpec = (QuerySpec)this.transformerRegistry.transform((Object)querySpecJson, QuerySpec.class).orElseThrow(InvalidRequestException::new);
        }
        return (JsonArray)((List)((ServiceResult)this.edrStore.query(querySpec).flatMap(ServiceResult::from)).orElseThrow(ServiceResultHandler.exceptionMapper(QuerySpec.class, null))).stream().map(it -> this.transformerRegistry.transform(it, JsonObject.class)).peek(r -> r.onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]))).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
    }

    public JsonObject getEdrEntryDataAddress(String transferProcessId) {
        DataAddress dataAddress = (DataAddress)((ServiceResult)this.edrStore.resolveByTransferProcess(transferProcessId).flatMap(ServiceResult::from)).orElseThrow(ServiceResultHandler.exceptionMapper(EndpointDataReferenceEntry.class, (String)transferProcessId));
        return (JsonObject)this.transformerRegistry.transform((Object)dataAddress, JsonObject.class).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }

    public void removeEdrEntry(String transferProcessId) {
        ((ServiceResult)this.edrStore.delete(transferProcessId).flatMap(ServiceResult::from)).orElseThrow(ServiceResultHandler.exceptionMapper(EndpointDataReferenceEntry.class, (String)transferProcessId));
    }
}

