/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.edr.v3;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import org.eclipse.edc.api.model.ApiCoreSchema;

@OpenAPIDefinition(info=@Info(version="v3"))
@Tag(name="EDR Cache V3")
public interface EdrCacheApiV3 {
    @Operation(description="Request all Edr entries according to a particular query", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ApiCoreSchema.QuerySpecSchema.class))}), responses={@ApiResponse(responseCode="200", description="The edr entries matching the query", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EndpointDataReferenceEntrySchema.class)))}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonArray requestEdrEntriesV3(JsonObject var1);

    @Operation(description="Gets the EDR data address with the given transfer process ID", responses={@ApiResponse(responseCode="200", description="The data address", content={@Content(schema=@Schema(implementation=ApiCoreSchema.DataAddressSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An EDR data address with the given transfer process ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public JsonObject getEdrEntryDataAddressV3(String var1);

    @Operation(description="Removes an EDR entry given the transfer process ID", responses={@ApiResponse(responseCode="204", description="EDR entry was deleted successfully"), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An EDR entry with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    public void removeEdrEntryV3(String var1);

    @ArraySchema
    @Schema(name="EndpointDataReferenceEntry", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"transfer-process-id\",\n    \"transferProcessId\": \"transfer-process-id\",\n    \"agreementId\": \"agreement-id\",\n    \"contractNegotiationId\": \"contract-negotiation-id\",\n    \"assetId\": \"asset-id\",\n    \"providerId\": \"provider-id\",\n    \"createdAt\": 1688465655\n}\n")
    public record EndpointDataReferenceEntrySchema(@Schema(name="@id") String id, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/EndpointDataReferenceEntry") String type) {
        public static final String EDR_ENTRY_OUTPUT_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"transfer-process-id\",\n    \"transferProcessId\": \"transfer-process-id\",\n    \"agreementId\": \"agreement-id\",\n    \"contractNegotiationId\": \"contract-negotiation-id\",\n    \"assetId\": \"asset-id\",\n    \"providerId\": \"provider-id\",\n    \"createdAt\": 1688465655\n}\n";
    }
}

