/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.version.http.api.transformer;

import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonCollectors;
import org.eclipse.edc.protocol.spi.ProtocolVersions;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromProtocolVersionsTransformer
implements TypeTransformer<ProtocolVersions, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromProtocolVersionsTransformer(JsonBuilderFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public Class<ProtocolVersions> getInputType() {
        return ProtocolVersions.class;
    }

    public Class<JsonObject> getOutputType() {
        return JsonObject.class;
    }

    @Nullable
    public JsonObject transform(@NotNull ProtocolVersions protocolVersions, @NotNull TransformerContext context) {
        JsonArray versions = (JsonArray)protocolVersions.protocolVersions().stream().map(version -> this.jsonFactory.createObjectBuilder().add("version", version.version()).add("path", version.path()).add("binding", version.binding()).build()).collect(JsonCollectors.toJsonArray());
        return this.jsonFactory.createObjectBuilder().add("protocolVersions", (JsonValue)versions).build();
    }
}

