/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.version.http.api;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.VersionProtocolService;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.protocol.dsp.version.http.api.DspVersionApiController;
import org.eclipse.edc.protocol.dsp.version.http.api.transformer.JsonObjectFromProtocolVersionsTransformer;
import org.eclipse.edc.protocol.dsp.version.http.api.transformer.JsonObjectFromVersionsError;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Dataspace Protocol Version Api")
public class DspVersionApiExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Version Api";
    @Inject
    private WebService webService;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private VersionProtocolService service;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonBuilderFactory jsonFactory = Json.createBuilderFactory(Map.of());
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromProtocolVersionsTransformer(jsonFactory));
        this.transformerRegistry.register((TypeTransformer)new JsonObjectFromVersionsError(jsonFactory));
        this.webService.registerResource("protocol", (Object)new DspVersionApiController(this.service, this.transformerRegistry));
    }
}

