/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.version.http.api;

import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.VersionProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.VersionsError;
import org.eclipse.edc.protocol.spi.ProtocolVersions;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Produces(value={"application/json"})
@Path(value="/.well-known/dspace-version")
public class DspVersionApiController {
    private final VersionProtocolService service;
    private final TypeTransformerRegistry transformerRegistry;

    public DspVersionApiController(VersionProtocolService service, TypeTransformerRegistry transformerRegistry) {
        this.service = service;
        this.transformerRegistry = transformerRegistry;
    }

    @GET
    public Response getProtocolVersions() {
        ServiceResult result = this.service.getAll();
        if (result.failed()) {
            return this.badRequest(result.getFailureMessages());
        }
        ProtocolVersions protocolVersions = (ProtocolVersions)result.getContent();
        Result body = this.transformerRegistry.transform((Object)protocolVersions, JsonObject.class);
        if (body.failed()) {
            return this.internalServerError(body.getFailureMessages());
        }
        return Response.status((Response.Status)Response.Status.OK).entity(body.getContent()).build();
    }

    private Response badRequest(List<String> messages) {
        return this.errorResponse(Response.Status.BAD_REQUEST, messages);
    }

    private Response internalServerError(List<String> messages) {
        return this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, messages);
    }

    private Response errorResponse(Response.Status status, List<String> messages) {
        VersionsError error = (VersionsError)((VersionsError.Builder)((VersionsError.Builder)VersionsError.Builder.newInstance().code(status.toString())).messages(messages)).build();
        JsonObject body = (JsonObject)this.transformerRegistry.transform((Object)error, JsonObject.class).orElseThrow(f -> new EdcException("Error creating response body: " + f.getFailureDetail()));
        return Response.status((Response.Status)status).entity((Object)body).build();
    }
}

