/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.version.http.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.ProtocolVersions;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.VersionProtocolService;
import org.eclipse.edc.connector.controlplane.services.spi.protocol.VersionsError;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.http.spi.message.GetDspRequest;

@Produces(value={"application/json"})
@Path(value="/.well-known/dspace-version")
public class DspVersionApiController {
    private final DspRequestHandler requestHandler;
    private final VersionProtocolService service;

    public DspVersionApiController(DspRequestHandler requestHandler, VersionProtocolService service) {
        this.requestHandler = requestHandler;
        this.service = service;
    }

    @GET
    public Response getProtocolVersions(@HeaderParam(value="Authorization") String token) {
        GetDspRequest request = (GetDspRequest)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)GetDspRequest.Builder.newInstance(ProtocolVersions.class, VersionsError.class).token(token)).serviceCall((id, tokenRepresentation) -> this.service.getAll(tokenRepresentation))).protocol("dataspace-protocol-http")).errorProvider(VersionsError.Builder::newInstance)).build();
        return this.requestHandler.getResource(request);
    }
}

