/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.version.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.edc.connector.spi.protocol.ProtocolVersions;
import org.eclipse.edc.connector.spi.protocol.VersionProtocolService;
import org.eclipse.edc.protocol.dsp.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.spi.message.GetDspRequest;

@Produces(value={"application/json"})
@Path(value="/.well-known/dspace-version")
public class DspVersionApiController {
    private final DspRequestHandler requestHandler;
    private final VersionProtocolService service;

    public DspVersionApiController(DspRequestHandler requestHandler, VersionProtocolService service) {
        this.requestHandler = requestHandler;
        this.service = service;
    }

    @GET
    public Response getProtocolVersions(@HeaderParam(value="Authorization") String token) {
        GetDspRequest request = (GetDspRequest)((GetDspRequest.Builder)((GetDspRequest.Builder)((GetDspRequest.Builder)GetDspRequest.Builder.newInstance(ProtocolVersions.class).token(token)).errorType("https://w3id.org/dspace/v0.8/VersionsError")).serviceCall((id, tokenRepresentation) -> this.service.getAll(tokenRepresentation))).build();
        return this.requestHandler.getResource(request);
    }
}

