/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.jsonld.transformer.from.JsonObjectFromAssetTransformer;
import org.eclipse.edc.jsonld.transformer.from.JsonObjectFromCatalogTransformer;
import org.eclipse.edc.jsonld.transformer.from.JsonObjectFromCriterionTransformer;
import org.eclipse.edc.jsonld.transformer.from.JsonObjectFromDataServiceTransformer;
import org.eclipse.edc.jsonld.transformer.from.JsonObjectFromDatasetTransformer;
import org.eclipse.edc.jsonld.transformer.from.JsonObjectFromDistributionTransformer;
import org.eclipse.edc.jsonld.transformer.from.JsonObjectFromPolicyTransformer;
import org.eclipse.edc.jsonld.transformer.from.JsonObjectFromQuerySpecTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToActionTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToAssetTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToCatalogTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToConstraintTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToCriterionTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToDataServiceTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToDatasetTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToDistributionTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToDutyTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToOperatorTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToPermissionTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToPolicyTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToProhibitionTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonObjectToQuerySpecTransformer;
import org.eclipse.edc.jsonld.transformer.to.JsonValueToGenericTypeTransformer;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Extension(value="Dataspace Protocol Transform Extension")
public class DspTransformExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Transform Extension";
    @Inject
    private TypeManager typeManager;
    @Inject
    private TypeTransformerRegistry registry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        ObjectMapper mapper = this.typeManager.getMapper("json-ld");
        mapper.registerSubtypes(new Class[]{AtomicConstraint.class, LiteralExpression.class});
        JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Map.of());
        this.registry.register((TypeTransformer)new JsonObjectFromCatalogTransformer(jsonBuilderFactory, mapper));
        this.registry.register((TypeTransformer)new JsonObjectFromDatasetTransformer(jsonBuilderFactory, mapper));
        this.registry.register((TypeTransformer)new JsonObjectFromPolicyTransformer(jsonBuilderFactory));
        this.registry.register((TypeTransformer)new JsonObjectFromDistributionTransformer(jsonBuilderFactory));
        this.registry.register((TypeTransformer)new JsonObjectFromDataServiceTransformer(jsonBuilderFactory));
        this.registry.register((TypeTransformer)new JsonObjectFromAssetTransformer(jsonBuilderFactory, mapper));
        this.registry.register((TypeTransformer)new JsonObjectFromQuerySpecTransformer(jsonBuilderFactory));
        this.registry.register((TypeTransformer)new JsonObjectFromCriterionTransformer(jsonBuilderFactory, mapper));
        this.registry.register((TypeTransformer)new JsonObjectToCatalogTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToDataServiceTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToDatasetTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToDistributionTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToPolicyTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToPermissionTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToProhibitionTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToDutyTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToActionTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToConstraintTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToOperatorTransformer());
        this.registry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(mapper));
        this.registry.register((TypeTransformer)new JsonObjectToAssetTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToQuerySpecTransformer());
        this.registry.register((TypeTransformer)new JsonObjectToCriterionTransformer());
    }
}

