/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Map;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferSuspensionMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.UnexpectedTypeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToTransferSuspensionMessageTransformer
extends AbstractJsonLdTransformer<JsonObject, TransferSuspensionMessage> {
    private final ObjectMapper objectMapper;

    public JsonObjectToTransferSuspensionMessageTransformer(ObjectMapper objectMapper) {
        super(JsonObject.class, TransferSuspensionMessage.class);
        this.objectMapper = objectMapper;
    }

    @Nullable
    public TransferSuspensionMessage transform(@NotNull JsonObject messageObject, @NotNull TransformerContext context) {
        JsonValue reasons;
        TransferSuspensionMessage.Builder builder = TransferSuspensionMessage.Builder.newInstance();
        if (!this.transformMandatoryString((JsonValue)messageObject.get((Object)"https://w3id.org/dspace/v0.8/consumerPid"), arg_0 -> ((TransferSuspensionMessage.Builder)builder).consumerPid(arg_0), context)) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/TransferSuspensionMessage")).property("https://w3id.org/dspace/v0.8/consumerPid")).report();
            return null;
        }
        if (!this.transformMandatoryString((JsonValue)messageObject.get((Object)"https://w3id.org/dspace/v0.8/providerPid"), arg_0 -> ((TransferSuspensionMessage.Builder)builder).providerPid(arg_0), context)) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("https://w3id.org/dspace/v0.8/TransferSuspensionMessage")).property("https://w3id.org/dspace/v0.8/providerPid")).report();
            return null;
        }
        if (messageObject.containsKey((Object)"https://w3id.org/dspace/v0.8/code")) {
            this.transformString((JsonValue)messageObject.get((Object)"https://w3id.org/dspace/v0.8/code"), arg_0 -> ((TransferSuspensionMessage.Builder)builder).code(arg_0), context);
        }
        if ((reasons = (JsonValue)messageObject.get((Object)"https://w3id.org/dspace/v0.8/reason")) != null) {
            JsonArray array;
            if (reasons instanceof JsonArray && !(array = (JsonArray)reasons).isEmpty()) {
                builder.reason(array.stream().map(this::deserialize).toList());
            } else {
                ((UnexpectedTypeBuilder)((UnexpectedTypeBuilder)context.problem().unexpectedType().type("https://w3id.org/dspace/v0.8/TransferTerminationMessage")).property("https://w3id.org/dspace/v0.8/reason")).actual((Enum)reasons.getValueType()).expected((Enum)JsonValue.ValueType.ARRAY).report();
            }
        }
        return (TransferSuspensionMessage)builder.build();
    }

    private Object deserialize(JsonValue it) {
        try {
            return this.objectMapper.readValue(it.toString(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new EdcException("Error deserializing 'reason' field.");
        }
    }
}

