/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcessStates;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromTransferProcessTransformer
extends AbstractJsonLdTransformer<TransferProcess, JsonObject> {
    private final JsonBuilderFactory jsonBuilderFactory;

    public JsonObjectFromTransferProcessTransformer(JsonBuilderFactory jsonBuilderFactory) {
        super(TransferProcess.class, JsonObject.class);
        this.jsonBuilderFactory = jsonBuilderFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull TransferProcess transferProcess, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonBuilderFactory.createObjectBuilder().add("@id", transferProcess.getId()).add("@type", "https://w3id.org/dspace/v0.8/TransferProcess").add("https://w3id.org/dspace/v0.8/state", TransferProcessStates.from((int)transferProcess.getState()).name());
        if (transferProcess.getType() == TransferProcess.Type.PROVIDER) {
            builder.add("https://w3id.org/dspace/v0.8/providerPid", transferProcess.getId());
            this.addIfNotNull(transferProcess.getCorrelationId(), "https://w3id.org/dspace/v0.8/consumerPid", builder);
        } else {
            builder.add("https://w3id.org/dspace/v0.8/consumerPid", transferProcess.getId());
            this.addIfNotNull(transferProcess.getCorrelationId(), "https://w3id.org/dspace/v0.8/providerPid", builder);
        }
        return builder.build();
    }
}

