/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferCompletionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferProcessTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferStartMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferSuspensionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferTerminationMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferCompletionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferProcessAckTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferStartMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferSuspensionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferTerminationMessageTransformer;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.transform.transformer.edc.from.JsonObjectFromDataAddressTransformer;

@Extension(value="Dataspace Protocol Transfer Process Transform Extension")
public class DspTransferProcessTransformExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Transfer Process Transform Extension";
    @Inject
    private TypeTransformerRegistry registry;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Map.of());
        ObjectMapper objectMapper = this.typeManager.getMapper("json-ld");
        TypeTransformerRegistry dspRegistry = this.registry.forContext("dsp-api");
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferProcessTransformer(builderFactory));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferStartMessageTransformer(builderFactory));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferCompletionMessageTransformer(builderFactory));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferTerminationMessageTransformer(builderFactory));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferRequestMessageTransformer(builderFactory));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferSuspensionMessageTransformer(builderFactory));
        dspRegistry.register((TypeTransformer)new JsonObjectFromDataAddressTransformer(builderFactory));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferRequestMessageTransformer());
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferCompletionMessageTransformer());
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferStartMessageTransformer());
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferTerminationMessageTransformer());
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferProcessAckTransformer());
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferSuspensionMessageTransformer(objectMapper));
    }
}

