/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Collection;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferSuspensionMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromTransferSuspensionMessageTransformer
extends AbstractJsonLdTransformer<TransferSuspensionMessage, JsonObject> {
    private final JsonBuilderFactory jsonBuilderFactory;

    public JsonObjectFromTransferSuspensionMessageTransformer(JsonBuilderFactory jsonBuilderFactory) {
        super(TransferSuspensionMessage.class, JsonObject.class);
        this.jsonBuilderFactory = jsonBuilderFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull TransferSuspensionMessage message, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonBuilderFactory.createObjectBuilder().add("@id", message.getId()).add("@type", "https://w3id.org/dspace/v0.8/TransferSuspensionMessage").add("https://w3id.org/dspace/v0.8/consumerPid", message.getConsumerPid()).add("https://w3id.org/dspace/v0.8/providerPid", message.getProviderPid()).add("https://w3id.org/dspace/v0.8/reason", this.jsonBuilderFactory.createArrayBuilder((Collection)message.getReason()));
        this.addIfNotNull(message.getCode(), "https://w3id.org/dspace/v0.8/code", builder);
        return builder.build();
    }
}

