/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Optional;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.protocol.TransferRequestMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromTransferRequestMessageTransformer
extends AbstractJsonLdTransformer<TransferRequestMessage, JsonObject> {
    private final JsonBuilderFactory jsonBuilderFactory;

    public JsonObjectFromTransferRequestMessageTransformer(JsonBuilderFactory jsonBuilderFactory) {
        super(TransferRequestMessage.class, JsonObject.class);
        this.jsonBuilderFactory = jsonBuilderFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull TransferRequestMessage transferRequestMessage, @NotNull TransformerContext context) {
        String format = Optional.ofNullable(transferRequestMessage.getTransferType()).orElseGet(() -> transferRequestMessage.getDataDestination().getType());
        JsonObjectBuilder builder = this.jsonBuilderFactory.createObjectBuilder().add("@id", transferRequestMessage.getId()).add("@type", "https://w3id.org/dspace/v0.8/TransferRequestMessage").add("https://w3id.org/dspace/v0.8/agreementId", transferRequestMessage.getContractId()).add("https://purl.org/dc/terms/format", format).add("http://purl.org/dc/terms/format", format).add("https://w3id.org/dspace/v0.8/callbackAddress", transferRequestMessage.getCallbackAddress()).add("https://w3id.org/dspace/v0.8/consumerPid", transferRequestMessage.getConsumerPid()).add("https://w3id.org/dspace/v0.8/processId", transferRequestMessage.getProcessId());
        if (transferRequestMessage.getDataDestination() != null && transferRequestMessage.getDataDestination().getProperties().size() > 1) {
            builder.add("https://w3id.org/dspace/v0.8/dataAddress", (JsonValue)context.transform((Object)transferRequestMessage.getDataDestination(), JsonObject.class));
        }
        return builder.build();
    }
}

