/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transformer.type.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferTerminationMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromTransferTerminationMessageTransformer
extends AbstractJsonLdTransformer<TransferTerminationMessage, JsonObject> {
    private final JsonBuilderFactory jsonBuilderFactory;

    public JsonObjectFromTransferTerminationMessageTransformer(JsonBuilderFactory jsonBuilderFactory) {
        super(TransferTerminationMessage.class, JsonObject.class);
        this.jsonBuilderFactory = jsonBuilderFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull TransferTerminationMessage transferTerminationMessage, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonBuilderFactory.createObjectBuilder();
        builder.add("@id", transferTerminationMessage.getId());
        builder.add("@type", "https://w3id.org/dspace/v0.8/TransferTerminationMessage");
        builder.add("https://w3id.org/dspace/v0.8/processId", transferTerminationMessage.getProcessId());
        if (transferTerminationMessage.getCode() != null) {
            builder.add("https://w3id.org/dspace/v0.8/code", transferTerminationMessage.getCode());
        }
        if (transferTerminationMessage.getReason() != null) {
            builder.add("https://w3id.org/dspace/v0.8/reason", transferTerminationMessage.getReason());
        }
        return builder.build();
    }
}

