/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transformer.type.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferStartMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromTransferStartMessageTransformer
extends AbstractJsonLdTransformer<TransferStartMessage, JsonObject> {
    private final JsonBuilderFactory jsonBuilderFactory;

    public JsonObjectFromTransferStartMessageTransformer(JsonBuilderFactory jsonBuilderFactory) {
        super(TransferStartMessage.class, JsonObject.class);
        this.jsonBuilderFactory = jsonBuilderFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull TransferStartMessage transferStartMessage, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonBuilderFactory.createObjectBuilder();
        builder.add("@id", transferStartMessage.getId());
        builder.add("@type", "https://w3id.org/dspace/v0.8/TransferStartMessage");
        builder.add("https://w3id.org/dspace/v0.8/processId", transferStartMessage.getProcessId());
        if (transferStartMessage.getDataAddress() != null) {
            builder.add("https://w3id.org/dspace/v0.8/dataAddress", (JsonValue)context.transform((Object)transferStartMessage.getDataAddress(), JsonObject.class));
        }
        return builder.build();
    }
}

