/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transformer.type.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferRequestMessage;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToTransferRequestMessageTransformer
extends AbstractJsonLdTransformer<JsonObject, TransferRequestMessage> {
    public JsonObjectToTransferRequestMessageTransformer() {
        super(JsonObject.class, TransferRequestMessage.class);
    }

    @Nullable
    public TransferRequestMessage transform(@NotNull JsonObject messageObject, @NotNull TransformerContext context) {
        TransferRequestMessage.Builder transferRequestMessageBuilder = TransferRequestMessage.Builder.newInstance();
        this.visitProperties(messageObject, k -> {
            switch (k) {
                case "https://w3id.org/dspace/v0.8/processId": {
                    return v -> transferRequestMessageBuilder.processId(this.transformString((JsonValue)v, context));
                }
                case "https://w3id.org/dspace/v0.8/agreementId": {
                    return v -> transferRequestMessageBuilder.contractId(this.transformString((JsonValue)v, context));
                }
                case "https://w3id.org/dspace/v0.8/callbackAddress": {
                    return v -> transferRequestMessageBuilder.callbackAddress(this.transformString((JsonValue)v, context));
                }
            }
            return JsonObjectToTransferRequestMessageTransformer.doNothing();
        });
        transferRequestMessageBuilder.dataDestination(this.createDataAddress(messageObject, context));
        return transferRequestMessageBuilder.build();
    }

    private DataAddress createDataAddress(@NotNull JsonObject requestObject, @NotNull TransformerContext context) {
        DataAddress.Builder dataAddressBuilder = DataAddress.Builder.newInstance();
        this.transformString((JsonValue)requestObject.get((Object)"https://purl.org/dc/terms/format"), arg_0 -> ((DataAddress.Builder)dataAddressBuilder).type(arg_0), context);
        JsonObject dataAddressObject = this.returnJsonObject((JsonValue)requestObject.get((Object)"https://w3id.org/dspace/v0.8/dataAddress"), context, "https://w3id.org/dspace/v0.8/dataAddress", false);
        if (dataAddressObject != null) {
            dataAddressObject.forEach((key, value) -> this.transformString((JsonValue)value, v -> dataAddressBuilder.property(key, v), context));
        }
        return dataAddressBuilder.build();
    }
}

