/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.protocol.dsp.spi.type.DspConstants;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferCompletionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferErrorTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferProcessTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferStartMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferSuspensionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferTerminationMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferCompletionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferProcessAckTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferStartMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferSuspensionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferTerminationMessageTransformer;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Extension(value="Dataspace Protocol Transfer Process Transform Extension")
public class DspTransferProcessTransformExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Transfer Process Transform Extension";
    @Inject
    private TypeTransformerRegistry registry;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        ObjectMapper objectMapper = this.typeManager.getMapper("json-ld");
        this.registerTransformers("dsp-api:v0.8", DspConstants.DSP_NAMESPACE_V_08, objectMapper);
        this.registerTransformers("dsp-api:2024/1", DspConstants.DSP_NAMESPACE_V_2024_1, objectMapper);
    }

    private void registerTransformers(String version, JsonLdNamespace namespace, ObjectMapper objectMapper) {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry dspRegistry = this.registry.forContext(version);
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferProcessTransformer(builderFactory, namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferStartMessageTransformer(builderFactory, namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferCompletionMessageTransformer(builderFactory, namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferTerminationMessageTransformer(builderFactory, namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferRequestMessageTransformer(builderFactory, namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferSuspensionMessageTransformer(builderFactory, namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferErrorTransformer(builderFactory, namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferRequestMessageTransformer(namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferCompletionMessageTransformer(namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferStartMessageTransformer(namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferTerminationMessageTransformer(namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferProcessAckTransformer(namespace));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferSuspensionMessageTransformer(objectMapper, namespace));
    }
}

