/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.transferprocess.transform.v2025;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Map;
import org.eclipse.edc.protocol.dsp.spi.type.Dsp2025Constants;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.from.JsonObjectFromTransferErrorTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferCompletionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferProcessAckTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferRequestMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferStartMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferSuspensionMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.to.JsonObjectToTransferTerminationMessageTransformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.v2024.from.JsonObjectFromTransferCompletionMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.v2024.from.JsonObjectFromTransferProcessV2024Transformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.v2024.from.JsonObjectFromTransferRequestMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.v2024.from.JsonObjectFromTransferStartMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.v2024.from.JsonObjectFromTransferSuspensionMessageV2024Transformer;
import org.eclipse.edc.protocol.dsp.transferprocess.transform.type.v2024.from.JsonObjectFromTransferTerminationMessageV2024Transformer;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

@Extension(value="Dataspace Protocol 2025/1 Transfer Process Transform Extension")
public class DspTransferProcessTransformV2025Extension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol 2025/1 Transfer Process Transform Extension";
    @Inject
    private TypeTransformerRegistry registry;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.registerTransformers();
    }

    private void registerTransformers() {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Map.of());
        TypeTransformerRegistry dspRegistry = this.registry.forContext("dsp-api:2025-1");
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferErrorTransformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferRequestMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferCompletionMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferStartMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferTerminationMessageTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferProcessAckTransformer(Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectToTransferSuspensionMessageTransformer(this.typeManager, "json-ld", Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferProcessV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferRequestMessageV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferStartMessageV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferCompletionMessageV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferTerminationMessageV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
        dspRegistry.register((TypeTransformer)new JsonObjectFromTransferSuspensionMessageV2024Transformer(builderFactory, Dsp2025Constants.DSP_NAMESPACE_V_2025_1));
    }
}

